/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.item.custom.HickoryNutTrailMix;
import net.farkas.wildaside.util.HickoryColour;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ModRecipeProvider.smelting(recipeOutput, List.of((ItemLike)ModItems.VIBRION.get()), RecipeCategory.MISC, (ItemLike)Items.YELLOW_DYE, 0.25f, 200, "yellow dye");
        ModRecipeProvider.smelting(recipeOutput, List.of((ItemLike)ModBlocks.VIBRION_GEL.get()), RecipeCategory.MISC, (ItemLike)ModItems.VIBRION.get(), 0.25f, 200, "vibrion");
        ModRecipeProvider.smelting(recipeOutput, List.of((ItemLike)ModBlocks.LIT_VIBRION_GEL.get()), RecipeCategory.MISC, (ItemLike)ModItems.VIBRION.get(), 0.25f, 200, "vibrion");
        this.simpleShapedRecipe((ItemLike)ModBlocks.VIBRION_BLOCK.get(), 1, (ItemLike)ModItems.VIBRION.get()).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.VIBRION.get()), (int)4).requires((ItemLike)ModBlocks.VIBRION_BLOCK.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModBlocks.VIBRION_BLOCK.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.VIBRION_BLOCK.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.VIBRION_GLASS_PANE.get()), (int)16).pattern("SSS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)ModBlocks.VIBRION_GLASS.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModBlocks.VIBRION_GLASS.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.VIBRION_GLASS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.LIT_VIBRION_GLASS_PANE.get()), (int)16).pattern("SSS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)ModBlocks.LIT_VIBRION_GLASS.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModBlocks.LIT_VIBRION_GLASS.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.LIT_VIBRION_GLASS.get()))).save(recipeOutput);
        ModRecipeProvider.smelting(recipeOutput, List.of((ItemLike)ModBlocks.ENTORIUM_ORE.get()), RecipeCategory.MISC, (ItemLike)ModItems.ENTORIUM.get(), 0.5f, 200, "entorium");
        ModRecipeProvider.blasting(recipeOutput, List.of((ItemLike)ModBlocks.ENTORIUM_ORE.get()), RecipeCategory.MISC, (ItemLike)ModItems.ENTORIUM.get(), 0.5f, 100, "entorium");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.BIOENGINEERING_WORKSTATION.get())).pattern("ECE").pattern("VQV").define(Character.valueOf('Q'), (ItemLike)Blocks.QUARTZ_BLOCK).define(Character.valueOf('C'), (ItemLike)Blocks.CRAFTING_TABLE).define(Character.valueOf('V'), (ItemLike)ModBlocks.VIBRION_BLOCK.get()).define(Character.valueOf('E'), (ItemLike)ModItems.ENTORIUM.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModBlocks.VIBRION_BLOCK.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.VIBRION_BLOCK.get()))).save(recipeOutput);
        List<ItemLike> SUBSTILIUM_WOODSET = List.of(((Block)ModBlocks.SUBSTILIUM_STEM.get()).asItem(), (ItemLike)ModBlocks.STRIPPED_SUBSTILIUM_STEM.get(), (ItemLike)ModBlocks.SUBSTILIUM_WOOD.get(), (ItemLike)ModBlocks.STRIPPED_SUBSTILIUM_WOOD.get(), (ItemLike)ModBlocks.SUBSTILIUM_PLANKS.get(), (ItemLike)ModBlocks.SUBSTILIUM_STAIRS.get(), (ItemLike)ModBlocks.SUBSTILIUM_SLAB.get(), (ItemLike)ModBlocks.SUBSTILIUM_FENCE.get(), (ItemLike)ModBlocks.SUBSTILIUM_FENCE_GATE.get(), (ItemLike)ModBlocks.SUBSTILIUM_PRESSURE_PLATE.get(), (ItemLike)ModBlocks.SUBSTILIUM_BUTTON.get(), (ItemLike)ModBlocks.SUBSTILIUM_DOOR.get(), (ItemLike)ModBlocks.SUBSTILIUM_TRAPDOOR.get(), (ItemLike)ModBlocks.SUBSTILIUM_SIGN.get(), (ItemLike)ModBlocks.SUBSTILIUM_HANGING_SIGN.get(), (ItemLike)ModItems.SUBSTILIUM_BOAT.get(), (ItemLike)ModItems.SUBSTILIUM_CHEST_BOAT.get());
        ModRecipeProvider.defaultWoodSet(recipeOutput, SUBSTILIUM_WOODSET);
        this.simpleShapedRecipe((ItemLike)ModBlocks.COMPRESSED_SUBSTILIUM_SOIL.get(), 2, (ItemLike)ModBlocks.SUBSTILIUM_SOIL.get(), RecipeCategory.BUILDING_BLOCKS).save(recipeOutput);
        this.simpleShapedRecipe((ItemLike)ModBlocks.SMOOTH_SUBSTILIUM_SOIL.get(), 4, (ItemLike)ModBlocks.COMPRESSED_SUBSTILIUM_SOIL.get(), RecipeCategory.BUILDING_BLOCKS).save(recipeOutput);
        this.simpleShapedRecipe((ItemLike)ModBlocks.SUBSTILIUM_TILES.get(), 4, (ItemLike)ModBlocks.SMOOTH_SUBSTILIUM_SOIL.get(), RecipeCategory.BUILDING_BLOCKS).save(recipeOutput);
        Block tiles = (Block)ModBlocks.SUBSTILIUM_TILES.get();
        ModRecipeProvider.stoneCutting(recipeOutput, (ItemLike)ModBlocks.COMPRESSED_SUBSTILIUM_SOIL.get(), (ItemLike)ModBlocks.CHISELED_SUBSTILIUM_SOIL.get());
        ModRecipeProvider.stoneCutting(recipeOutput, (ItemLike)ModBlocks.COMPRESSED_SUBSTILIUM_SOIL.get(), (ItemLike)ModBlocks.SMOOTH_SUBSTILIUM_SOIL.get());
        ModRecipeProvider.stoneCutting(recipeOutput, (ItemLike)ModBlocks.COMPRESSED_SUBSTILIUM_SOIL.get(), (ItemLike)tiles);
        ModRecipeProvider.stoneCutting(recipeOutput, (ItemLike)ModBlocks.COMPRESSED_SUBSTILIUM_SOIL.get(), (ItemLike)ModBlocks.CRACKED_SUBSTILIUM_TILES.get());
        ModRecipeProvider.stoneCutting(recipeOutput, (ItemLike)ModBlocks.SMOOTH_SUBSTILIUM_SOIL.get(), (ItemLike)tiles);
        ModRecipeProvider.stoneCutting(recipeOutput, (ItemLike)ModBlocks.SMOOTH_SUBSTILIUM_SOIL.get(), (ItemLike)ModBlocks.CRACKED_SUBSTILIUM_TILES.get());
        ModRecipeProvider.stoneCutting(recipeOutput, (ItemLike)tiles, (ItemLike)ModBlocks.CRACKED_SUBSTILIUM_TILES.get());
        ModRecipeProvider.stoneCutting(recipeOutput, (ItemLike)tiles, (ItemLike)ModBlocks.SUBSTILIUM_TILE_STAIRS.get());
        ModRecipeProvider.stoneCutting(recipeOutput, (ItemLike)tiles, (ItemLike)ModBlocks.SUBSTILIUM_TILE_SLAB.get());
        ModRecipeProvider.stoneCutting(recipeOutput, (ItemLike)tiles, (ItemLike)ModBlocks.SUBSTILIUM_TILE_BUTTON.get());
        ModRecipeProvider.stoneCutting(recipeOutput, (ItemLike)tiles, (ItemLike)ModBlocks.SUBSTILIUM_TILE_PRESSURE_PLATE.get());
        ModRecipeProvider.stoneCutting(recipeOutput, (ItemLike)tiles, (ItemLike)ModBlocks.SUBSTILIUM_TILE_WALLS.get());
        ModRecipeProvider.stairsRecipe(recipeOutput, (ItemLike)ModBlocks.SUBSTILIUM_TILE_STAIRS.get(), (ItemLike)tiles);
        ModRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SUBSTILIUM_TILE_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{tiles})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)tiles), ModRecipeProvider.has((ItemLike)tiles)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModBlocks.SUBSTILIUM_TILE_BUTTON.get())).requires((ItemLike)tiles).unlockedBy(ModRecipeProvider.getHasName((ItemLike)tiles), ModRecipeProvider.has((ItemLike)tiles)).save(recipeOutput);
        ModRecipeProvider.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModBlocks.SUBSTILIUM_TILE_PRESSURE_PLATE.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{tiles})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)tiles), ModRecipeProvider.has((ItemLike)tiles)).save(recipeOutput);
        ModRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SUBSTILIUM_TILE_WALLS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{tiles})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)tiles), ModRecipeProvider.has((ItemLike)tiles)).save(recipeOutput);
        ModRecipeProvider.smelting(recipeOutput, List.of(tiles), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.CRACKED_SUBSTILIUM_TILES.get(), 0.2f, 200, "cracked_substilium_tiles");
        ModRecipeProvider.smelting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_COAL_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.COAL, 0.2f, 200, "coal");
        ModRecipeProvider.blasting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_COAL_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.COAL, 0.3f, 100, "coal");
        ModRecipeProvider.smelting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_COPPER_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.COPPER_INGOT, 0.8f, 200, "copper_ingot");
        ModRecipeProvider.blasting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_COPPER_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.COPPER_INGOT, 0.8f, 100, "copper_ingot");
        ModRecipeProvider.smelting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_LAPIS_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.LAPIS_LAZULI, 0.3f, 200, "lapis");
        ModRecipeProvider.blasting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_LAPIS_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.LAPIS_LAZULI, 0.3f, 100, "lapis");
        ModRecipeProvider.smelting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_IRON_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.IRON_INGOT, 0.8f, 200, "iron_ingot");
        ModRecipeProvider.blasting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_IRON_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.IRON_INGOT, 0.8f, 100, "iron_ingot");
        ModRecipeProvider.smelting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_GOLD_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.GOLD_INGOT, 1.1f, 200, "gold_ingot");
        ModRecipeProvider.blasting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_GOLD_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.GOLD_INGOT, 1.1f, 100, "gold_ingot");
        ModRecipeProvider.smelting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_REDSTONE_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.REDSTONE, 0.4f, 200, "redstone");
        ModRecipeProvider.blasting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_REDSTONE_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.REDSTONE, 0.4f, 100, "redstone");
        ModRecipeProvider.smelting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_DIAMOND_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.DIAMOND, 1.1f, 200, "diamond");
        ModRecipeProvider.blasting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_DIAMOND_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.DIAMOND, 1.1f, 100, "diamond");
        ModRecipeProvider.smelting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_EMERALD_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.EMERALD, 1.1f, 200, "emerald");
        ModRecipeProvider.blasting(recipeOutput, List.of((ItemLike)ModBlocks.SUBSTILIUM_EMERALD_ORE.get()), RecipeCategory.MISC, (ItemLike)Items.EMERALD, 1.1f, 100, "emerald");
        List<ItemLike> HICKORY_WOODSET = List.of(((Block)ModBlocks.HICKORY_LOG.get()).asItem(), (ItemLike)ModBlocks.STRIPPED_HICKORY_LOG.get(), (ItemLike)ModBlocks.HICKORY_WOOD.get(), (ItemLike)ModBlocks.STRIPPED_HICKORY_WOOD.get(), (ItemLike)ModBlocks.HICKORY_PLANKS.get(), (ItemLike)ModBlocks.HICKORY_STAIRS.get(), (ItemLike)ModBlocks.HICKORY_SLAB.get(), (ItemLike)ModBlocks.HICKORY_FENCE.get(), (ItemLike)ModBlocks.HICKORY_FENCE_GATE.get(), (ItemLike)ModBlocks.HICKORY_PRESSURE_PLATE.get(), (ItemLike)ModBlocks.HICKORY_BUTTON.get(), (ItemLike)ModBlocks.HICKORY_DOOR.get(), (ItemLike)ModBlocks.HICKORY_TRAPDOOR.get(), (ItemLike)ModBlocks.HICKORY_SIGN.get(), (ItemLike)ModBlocks.HICKORY_HANGING_SIGN.get(), (ItemLike)ModItems.HICKORY_BOAT.get(), (ItemLike)ModItems.HICKORY_CHEST_BOAT.get());
        ModRecipeProvider.defaultWoodSet(recipeOutput, HICKORY_WOODSET);
        for (HickoryColour colour : HickoryColour.values()) {
            this.simpleShapedRecipe((ItemLike)ModBlocks.HICKORY_LEAVES_BLOCKS.get((Object)colour).get(), 1, (ItemLike)ModItems.LEAF_ITEMS.get((Object)colour).get()).save(recipeOutput);
            this.hickoryNutTrailMix((HickoryNutTrailMix)((Object)ModItems.TRAIL_MIX_ITEMS.get((Object)colour).get())).save(recipeOutput);
        }
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PINK_DYE, (int)1).requires((ItemLike)ModBlocks.PINKSTER_FLOWER.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModBlocks.PINKSTER_FLOWER.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.PINKSTER_FLOWER.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.WHITE_DYE, (int)1).requires((ItemLike)ModBlocks.SPOTTED_WINTERGREEN.get()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModBlocks.SPOTTED_WINTERGREEN.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.SPOTTED_WINTERGREEN.get()))).save(recipeOutput);
    }

    private ShapedRecipeBuilder simpleShapedRecipe(ItemLike output, int count, ItemLike input, RecipeCategory category) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)output, (int)count).pattern("SS").pattern("SS").define(Character.valueOf('S'), input).unlockedBy(ModRecipeProvider.getHasName((ItemLike)input), ModRecipeProvider.has((ItemLike)input));
    }

    private ShapedRecipeBuilder simpleShapedRecipe(ItemLike output, int count, ItemLike input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).pattern("SS").pattern("SS").define(Character.valueOf('S'), input).unlockedBy(ModRecipeProvider.getHasName((ItemLike)input), ModRecipeProvider.has((ItemLike)input));
    }

    private ShapelessRecipeBuilder hickoryNutTrailMix(HickoryNutTrailMix mixItem) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)mixItem).requires((ItemLike)ModItems.HICKORY_NUT.get()).requires((ItemLike)Items.BOWL).requires((ItemLike)Items.GLOW_BERRIES).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)ModItems.LEAF_ITEMS.get((Object)mixItem.getColour()).get(), 3).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.HICKORY_NUT.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.HICKORY_NUT.get())));
    }

    protected static void smelting(RecipeOutput recipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTIme, String pGroup) {
        ModRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTIme, pGroup, "_from_smelting");
    }

    protected static void blasting(RecipeOutput recipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        ModRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    protected static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput recipeOutput, RecipeSerializer<T> pCookingSerializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pRecipeName) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer, factory).group(pGroup).unlockedBy(ModRecipeProvider.getHasName((ItemLike)itemlike), ModRecipeProvider.has((ItemLike)itemlike)).save(recipeOutput, "wildaside:" + ModRecipeProvider.getItemName((ItemLike)pResult) + pRecipeName + "_" + ModRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }

    protected static void stoneCutting(RecipeOutput recipeOutput, ItemLike inputItem, ItemLike outputItem) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputItem}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem).unlockedBy(ModRecipeProvider.getHasName((ItemLike)inputItem), ModRecipeProvider.has((ItemLike)inputItem)).save(recipeOutput, "wildaside:" + ModRecipeProvider.getItemName((ItemLike)outputItem) + "cut_from_" + ModRecipeProvider.getItemName((ItemLike)inputItem));
    }

    protected static void stairsRecipe(RecipeOutput recipeOutput, ItemLike outputBlock, ItemLike inputBlock) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputBlock, (int)6).pattern("S  ").pattern("SS ").pattern("SSS").define(Character.valueOf('S'), inputBlock).unlockedBy(ModRecipeProvider.getHasName((ItemLike)inputBlock), ModRecipeProvider.has((ItemLike)inputBlock)).save(recipeOutput, "wildaside:" + ModRecipeProvider.getItemName((ItemLike)outputBlock) + "_1");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputBlock, (int)6).pattern("  S").pattern(" SS").pattern("SSS").define(Character.valueOf('S'), inputBlock).unlockedBy(ModRecipeProvider.getHasName((ItemLike)inputBlock), ModRecipeProvider.has((ItemLike)inputBlock)).save(recipeOutput, "wildaside:" + ModRecipeProvider.getItemName((ItemLike)outputBlock) + "_2");
    }

    private static void defaultWoodSet(RecipeOutput recipeOutput, List<ItemLike> blocks) {
        ItemLike log = blocks.get(0);
        ItemLike str_log = blocks.get(1);
        ItemLike wood = blocks.get(2);
        ItemLike str_wood = blocks.get(3);
        Ingredient planks = Ingredient.of((ItemLike[])new ItemLike[]{blocks.get(4)});
        ItemLike stairs = blocks.get(5);
        ItemLike slab = blocks.get(6);
        ItemLike fence = blocks.get(7);
        ItemLike gate = blocks.get(8);
        ItemLike press = blocks.get(9);
        ItemLike button = blocks.get(10);
        ItemLike door = blocks.get(11);
        ItemLike trapdoor = blocks.get(12);
        ItemLike sign = blocks.get(13);
        ItemLike hang_sign = blocks.get(14);
        ItemLike boat = blocks.get(15);
        ItemLike chest_boat = blocks.get(16);
        List<ItemLike> PLANKS_ORIGIN = List.of(log, str_log, wood, str_wood);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood, (int)4).pattern("SS").pattern("SS").define(Character.valueOf('S'), (ItemLike)log.asItem()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)log), ModRecipeProvider.has((ItemLike)log)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)str_wood, (int)4).pattern("SS").pattern("SS").define(Character.valueOf('S'), (ItemLike)str_log.asItem()).unlockedBy(ModRecipeProvider.getHasName((ItemLike)str_log), ModRecipeProvider.has((ItemLike)str_log)).save(recipeOutput);
        for (ItemLike itemLike : PLANKS_ORIGIN) {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)blocks.get(4), (int)4).requires(itemLike).unlockedBy(ModRecipeProvider.getHasName((ItemLike)itemLike), ModRecipeProvider.has((ItemLike)itemLike)).group(ModRecipeProvider.getItemName((ItemLike)blocks.get(4))).save(recipeOutput, "wildaside:" + ModRecipeProvider.getItemName((ItemLike)blocks.get(4)) + "_" + ModRecipeProvider.getItemName((ItemLike)itemLike));
        }
        ModRecipeProvider.stairsRecipe(recipeOutput, stairs, blocks.get(4));
        ModRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (Ingredient)planks).unlockedBy(ModRecipeProvider.getHasName((ItemLike)blocks.get(4)), ModRecipeProvider.has((ItemLike)blocks.get(4))).save(recipeOutput);
        ModRecipeProvider.fenceBuilder((ItemLike)fence, (Ingredient)planks).unlockedBy(ModRecipeProvider.getHasName((ItemLike)blocks.get(4)), ModRecipeProvider.has((ItemLike)blocks.get(4))).save(recipeOutput);
        ModRecipeProvider.fenceGateBuilder((ItemLike)gate, (Ingredient)planks).unlockedBy(ModRecipeProvider.getHasName((ItemLike)blocks.get(4)), ModRecipeProvider.has((ItemLike)blocks.get(4))).save(recipeOutput);
        ModRecipeProvider.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)press, (Ingredient)planks).unlockedBy(ModRecipeProvider.getHasName((ItemLike)blocks.get(4)), ModRecipeProvider.has((ItemLike)blocks.get(4))).save(recipeOutput);
        ModRecipeProvider.buttonBuilder((ItemLike)button, (Ingredient)planks).unlockedBy(ModRecipeProvider.getHasName((ItemLike)blocks.get(4)), ModRecipeProvider.has((ItemLike)blocks.get(4))).save(recipeOutput);
        ModRecipeProvider.doorBuilder((ItemLike)door, (Ingredient)planks).unlockedBy(ModRecipeProvider.getHasName((ItemLike)blocks.get(4)), ModRecipeProvider.has((ItemLike)blocks.get(4))).save(recipeOutput);
        ModRecipeProvider.trapdoorBuilder((ItemLike)trapdoor, (Ingredient)planks).unlockedBy(ModRecipeProvider.getHasName((ItemLike)blocks.get(4)), ModRecipeProvider.has((ItemLike)blocks.get(4))).save(recipeOutput);
        ModRecipeProvider.signBuilder((ItemLike)sign, (Ingredient)planks).unlockedBy(ModRecipeProvider.getHasName((ItemLike)blocks.get(4)), ModRecipeProvider.has((ItemLike)blocks.get(4))).save(recipeOutput);
        ModRecipeProvider.hangingSign((RecipeOutput)recipeOutput, (ItemLike)hang_sign, (ItemLike)blocks.get(4));
        ModRecipeProvider.woodenBoat((RecipeOutput)recipeOutput, (ItemLike)boat, (ItemLike)blocks.get(4));
        ModRecipeProvider.chestBoat((RecipeOutput)recipeOutput, (ItemLike)chest_boat, (ItemLike)blocks.get(15));
    }
}

