/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.ai.hickory;

import java.util.EnumSet;
import net.farkas.wildaside.entity.custom.hickory.HickoryTreantEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class HickoryTreantBeamAttackGoal
extends Goal {
    private final HickoryTreantEntity entity;
    private static final int minRange = 3;
    private static final int maxRange = 24;

    public HickoryTreantBeamAttackGoal(HickoryTreantEntity entity) {
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity target = this.entity.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        double distance = this.entity.distanceTo((Entity)target);
        return this.entity.beamCooldown <= 0 && distance > 3.0 && distance <= 24.0;
    }

    public void tick() {
        int phase = this.entity.getPhase();
        this.entity.doBeamAttack(phase);
        this.entity.beamCooldown = this.entity.getBeamInterval(phase);
    }
}

