/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.custom.hickory;

import net.farkas.wildaside.entity.ModEntities;
import net.farkas.wildaside.entity.custom.hickory.HickoryTreantEntity;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.util.HickoryColour;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class HickoryLeafProjectile
extends ThrowableItemProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<Integer> COLOUR = SynchedEntityData.defineId(HickoryLeafProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int phase = 0;

    public HickoryLeafProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public HickoryLeafProjectile(Level world, LivingEntity shooter, HickoryColour colour) {
        super(ModEntities.HICKORY_LEAF_PROJECTILE.get(), shooter, world);
        this.entityData.set(COLOUR, (Object)colour.ordinal());
        if (shooter instanceof HickoryTreantEntity) {
            HickoryTreantEntity hickoryTreant = (HickoryTreantEntity)shooter;
            this.phase = hickoryTreant.getPhase();
        }
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.HICKORY_LEAF.get();
    }

    public ItemStack getItem() {
        return switch (this.getColour()) {
            case HickoryColour.RED_GLOWING -> new ItemStack((ItemLike)ModItems.RED_GLOWING_HICKORY_LEAF.get());
            case HickoryColour.BROWN_GLOWING -> new ItemStack((ItemLike)ModItems.BROWN_GLOWING_HICKORY_LEAF.get());
            case HickoryColour.YELLOW_GLOWING -> new ItemStack((ItemLike)ModItems.YELLOW_GLOWING_HICKORY_LEAF.get());
            case HickoryColour.GREEN_GLOWING -> new ItemStack((ItemLike)ModItems.GREEN_GLOWING_HICKORY_LEAF.get());
            default -> new ItemStack((ItemLike)ModItems.HICKORY_LEAF.get());
        };
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            target.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 0, false, false));
            switch (this.getColour()) {
                case RED_GLOWING: {
                    target.igniteForSeconds((float)(4 + this.phase));
                    break;
                }
                case BROWN_GLOWING: {
                    target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, this.phase - 1));
                    break;
                }
                case YELLOW_GLOWING: {
                    target.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0));
                    target.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 100, 0));
                    break;
                }
                case GREEN_GLOWING: {
                    this.healEffect();
                    break;
                }
            }
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    private void healEffect() {
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)entity;
            shooter.heal((float)this.phase);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(COLOUR, (Object)HickoryColour.HICKORY.ordinal());
    }

    private HickoryColour getColour() {
        int id = (Integer)this.entityData.get(COLOUR);
        return HickoryColour.values()[Mth.clamp((int)id, (int)0, (int)(HickoryColour.values().length - 1))];
    }
}

