/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.custom.hickory;

import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.block.custom.RootBushBlock;
import net.farkas.wildaside.entity.ai.hickory.HickoryTreantBeamAttackGoal;
import net.farkas.wildaside.entity.ai.hickory.HickoryTreantMeleeAttackGoal;
import net.farkas.wildaside.entity.ai.hickory.HickoryTreantRootAttackGoal;
import net.farkas.wildaside.entity.custom.hickory.HickoryLeafProjectile;
import net.farkas.wildaside.util.HickoryColour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HickoryTreantEntity
extends Monster {
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.defineId(HickoryTreantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int rootCooldown;
    public int beamCooldown;
    public int previousAttackX = 0;
    public int previousAttackY = 0;
    public int previousAttackZ = 0;
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.translatable((String)"entity.wildaside.hickory_treant"), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.NOTCHED_12);

    public HickoryTreantEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.rootCooldown = this.getRootInterval(1);
        this.beamCooldown = this.getBeamInterval(1);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 36.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.8);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Blaze.class, false));
        this.goalSelector.addGoal(3, (Goal)new HickoryTreantRootAttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new HickoryTreantBeamAttackGoal(this));
        this.goalSelector.addGoal(4, (Goal)new HickoryTreantMeleeAttackGoal((PathfinderMob)this, 0.5, true));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 36.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Blaze.class, 36.0f));
    }

    public void remove(Entity.RemovalReason pReason) {
        super.remove(pReason);
        this.resetRoots();
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(PHASE, (Object)1);
    }

    public int getPhase() {
        return (Integer)this.entityData.get(PHASE);
    }

    public void setPhase(int phase) {
        this.entityData.set(PHASE, (Object)phase);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.animationHandler();
        }
    }

    private void animationHandler() {
    }

    public void aiStep() {
        super.aiStep();
        --this.rootCooldown;
        --this.beamCooldown;
        this.setPhase(this.updatePhase());
        if (this.getTarget() != null) {
            this.getNavigation().moveTo((Entity)this.getTarget(), 1.0);
            this.getLookControl().setLookAt((Entity)this.getTarget(), 30.0f, 30.0f);
        }
        this.bossEvent.setProgress(this.healthPresentage());
        switch (this.getPhase()) {
            case 1: {
                this.bossEvent.setColor(BossEvent.BossBarColor.GREEN);
                break;
            }
            case 2: {
                this.bossEvent.setColor(BossEvent.BossBarColor.YELLOW);
                break;
            }
            case 3: {
                this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, -1, 0, false, false));
                this.bossEvent.setColor(BossEvent.BossBarColor.RED);
                break;
            }
            case 4: {
                this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, -1, 1, false, false));
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, -1, 1, false, false));
                this.bossEvent.setColor(BossEvent.BossBarColor.WHITE);
            }
        }
    }

    public float healthPresentage() {
        return this.getHealth() / this.getMaxHealth();
    }

    private int updatePhase() {
        double percent = this.healthPresentage();
        if (percent <= 0.25) {
            return 4;
        }
        if (percent <= 0.5) {
            return 3;
        }
        if (percent <= 0.75) {
            return 2;
        }
        return 1;
    }

    public int getRootInterval(int phase) {
        return switch (phase) {
            case 2 -> 140;
            case 3 -> 120;
            case 4 -> 100;
            default -> 160;
        };
    }

    public int getBeamInterval(int phase) {
        return switch (phase) {
            case 3 -> 80;
            case 4 -> 60;
            default -> 100;
        };
    }

    public int getRootPatchRadius(int phase) {
        return phase >= 3 ? 2 : 1;
    }

    public void doRootingAttack(int phase) {
        this.resetRoots();
        Level level = this.level();
        BlockPos rootPos = this.getTarget().blockPosition().below();
        this.previousAttackX = rootPos.getX();
        this.previousAttackY = rootPos.getY();
        this.previousAttackZ = rootPos.getZ();
        int radius = this.getRootPatchRadius(phase);
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos;
                    BlockPos placePos;
                    if (Math.abs(dx) == radius && Math.abs(dz) == radius || !level.isEmptyBlock(placePos = (pos = rootPos.offset(dx, dy, dz)).above()) && !level.getBlockState(placePos).canBeReplaced() || !level.getBlockState(pos).isFaceSturdy((BlockGetter)level, pos, Direction.UP)) continue;
                    level.setBlock(placePos, (BlockState)((Block)ModBlocks.HICKORY_ROOT_BUSH.get()).defaultBlockState().setValue((Property)RootBushBlock.AGE, (Comparable)Integer.valueOf(phase - 1)), 3);
                }
            }
        }
    }

    public void resetRoots() {
        Level level = this.level();
        BlockPos rootPos = new BlockPos(this.previousAttackX, this.previousAttackY, this.previousAttackZ);
        int radius = 2;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos = rootPos.offset(dx, dy, dz);
                    BlockPos placePos = pos.above();
                    if (!(level.getBlockState(placePos).getBlock() instanceof RootBushBlock)) continue;
                    level.removeBlock(placePos, false);
                }
            }
        }
    }

    public void doBeamAttack(int phase) {
        Level level = this.level();
        LivingEntity target = this.getTarget();
        RandomSource random = this.getRandom();
        HickoryColour[] values = HickoryColour.values();
        HickoryColour colour = values[random.nextInt(values.length)];
        int count = phase * 8;
        float speed = phase >= 3 ? 2.0f : 1.5f;
        Vec3 start = this.position().add(0.0, (double)this.getEyeHeight() * 0.5, 0.0);
        Vec3 targetPos = target.position().add(0.0, (double)target.getEyeHeight() * 0.5, 0.0);
        Vec3 delta = targetPos.subtract(start);
        for (int i = 0; i < count; ++i) {
            HickoryLeafProjectile proj = new HickoryLeafProjectile(level, (LivingEntity)this, colour);
            proj.setPos(start);
            proj.shoot(delta.x, delta.y, delta.z, speed, 40 - phase * 2);
            level.addFreshEntity((Entity)proj);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("phase", this.getPhase());
        tag.putInt("rootCD", this.rootCooldown);
        tag.putInt("beamCD", this.beamCooldown);
        tag.putInt("paX", this.previousAttackX);
        tag.putInt("paY", this.previousAttackY);
        tag.putInt("paZ", this.previousAttackZ);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setPhase(tag.getInt("phase"));
        this.rootCooldown = tag.getInt("rootCD");
        this.beamCooldown = tag.getInt("beamCD");
        this.previousAttackX = tag.getInt("paX");
        this.previousAttackY = tag.getInt("paY");
        this.previousAttackZ = tag.getInt("paZ");
    }

    public void startSeenByPlayer(ServerPlayer pServerPlayer) {
        super.startSeenByPlayer(pServerPlayer);
        this.bossEvent.addPlayer(pServerPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer pServerPlayer) {
        super.stopSeenByPlayer(pServerPlayer);
        this.bossEvent.removePlayer(pServerPlayer);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (pSource.is(DamageTypes.ON_FIRE) || pSource.is(DamageTypes.IN_FIRE)) {
            pAmount *= 2.0f;
        }
        return super.hurt(pSource, pAmount);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.WOOD_STEP;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.WOOD_HIT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.WOOD_BREAK;
    }
}

