/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.custom.vibrion;

import java.util.ArrayList;
import java.util.List;
import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.entity.ModEntities;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.util.AdvancementHandler;
import net.farkas.wildaside.util.WeightedFlowerChoice;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FertiliserBombEntity
extends ThrowableItemProjectile {
    private final float charge;
    private final LivingEntity thrower;
    final List<WeightedFlowerChoice.WeightedFlower> flowerList = new ArrayList<WeightedFlowerChoice.WeightedFlower>(List.of(new WeightedFlowerChoice.WeightedFlower(5, Blocks.DANDELION), new WeightedFlowerChoice.WeightedFlower(5, Blocks.POPPY), new WeightedFlowerChoice.WeightedFlower(3, Blocks.BLUE_ORCHID), new WeightedFlowerChoice.WeightedFlower(2, Blocks.ALLIUM), new WeightedFlowerChoice.WeightedFlower(2, Blocks.ORANGE_TULIP), new WeightedFlowerChoice.WeightedFlower(2, Blocks.PINK_TULIP), new WeightedFlowerChoice.WeightedFlower(2, Blocks.RED_TULIP), new WeightedFlowerChoice.WeightedFlower(2, Blocks.WHITE_TULIP), new WeightedFlowerChoice.WeightedFlower(2, Blocks.OXEYE_DAISY), new WeightedFlowerChoice.WeightedFlower(2, Blocks.CORNFLOWER), new WeightedFlowerChoice.WeightedFlower(1, Blocks.AZURE_BLUET)));
    final WeightedFlowerChoice flowerChoice = new WeightedFlowerChoice(this.flowerList);

    public FertiliserBombEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.charge = this.level().random.nextFloat();
        this.thrower = null;
    }

    public FertiliserBombEntity(Level pLevel, LivingEntity thrower, float charge) {
        super(ModEntities.FERTILISER_BOMB.get(), thrower, pLevel);
        this.charge = charge + 0.1f;
        this.thrower = thrower;
    }

    public FertiliserBombEntity(Level level, double x, double y, double z) {
        super(ModEntities.FERTILISER_BOMB.get(), x, y, z, level);
        this.charge = this.level().random.nextFloat();
        this.thrower = null;
    }

    public FertiliserBombEntity(Level level) {
        super(ModEntities.FERTILISER_BOMB.get(), level);
        this.charge = level.random.nextFloat();
        this.thrower = null;
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.FERTILISER_BOMB.get();
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide && result.getType() == HitResult.Type.BLOCK) {
            Vec3 loc = result.getLocation();
            BlockPos impactPos = new BlockPos((int)loc.x, (int)loc.y, (int)loc.z);
            this.applyAreaEffect((ServerLevel)this.level(), impactPos, this.charge);
            this.discard();
        }
    }

    private void applyAreaEffect(ServerLevel level, BlockPos center, float charge) {
        int radius = Mth.ceil((float)(2.0f + charge * 2.0f));
        int verticalRange = 1;
        int radiusSq = radius * radius;
        RandomSource random = level.getRandom();
        Holder biomeHolder = level.getBiome(center);
        String biomePath = biomeHolder.unwrapKey().map(key -> key.location().getPath()).orElse("");
        if (biomePath.contains("hickory")) {
            AdvancementHandler.givePlayerAdvancement((Entity)((ServerPlayer)this.thrower), "fertile_forest");
            this.flowerList.add(new WeightedFlowerChoice.WeightedFlower(4, (Block)ModBlocks.SPOTTED_WINTERGREEN.get()));
            this.flowerList.add(new WeightedFlowerChoice.WeightedFlower(4, (Block)ModBlocks.PINKSTER_FLOWER.get()));
        }
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                if (dx * dx + dz * dz > radiusSq) continue;
                for (int dy = -verticalRange; dy <= verticalRange; ++dy) {
                    BlockPos pos = center.offset(dx, dy, dz);
                    this.applyEffectAt(level, pos, random, charge);
                }
            }
        }
    }

    private void applyEffectAt(ServerLevel level, BlockPos pos, RandomSource random, float charge) {
        BonemealableBlock bonemealBlockBelow;
        BlockPos below;
        BlockState belowState;
        Block block;
        BonemealableBlock bonemealBlock;
        BlockState state = level.getBlockState(pos);
        Block block2 = state.getBlock();
        if (block2 instanceof FarmBlock) {
            FarmBlock farm = (FarmBlock)block2;
            if (this.chance(random, charge * 0.5f)) {
                int moisture = (Integer)state.getValue((Property)FarmBlock.MOISTURE);
                if (moisture < 7) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7)), 3);
                    this.spawnSplash((Level)level, pos);
                }
                return;
            }
        }
        if (state.isAir() && level.getBlockState(pos.below()).is(BlockTags.DIRT) && this.chance(random, charge * 0.3f)) {
            BlockState flower = this.flowerChoice.selectFlower(random);
            level.setBlock(pos, flower, 3);
            this.spawnHappy((Level)level, pos);
            return;
        }
        Block moisture = state.getBlock();
        if (moisture instanceof BonemealableBlock && (bonemealBlock = (BonemealableBlock)moisture).isValidBonemealTarget((LevelReader)level, pos, state) && this.chance(random, charge * 0.3f)) {
            bonemealBlock.performBonemeal(level, random, pos, state);
            level.levelEvent(2005, pos, 0);
            this.spawnSplash((Level)level, pos);
            return;
        }
        if (state.isAir() && (block = (belowState = level.getBlockState(below = pos.below())).getBlock()) instanceof BonemealableBlock && (bonemealBlockBelow = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, below, belowState) && this.chance(random, charge * 0.2f)) {
            bonemealBlockBelow.performBonemeal(level, random, below, belowState);
            level.levelEvent(2005, below, 0);
            this.spawnSplash((Level)level, pos);
        }
    }

    private boolean chance(RandomSource random, float factor) {
        return random.nextFloat() < factor;
    }

    private void spawnSplash(Level level, BlockPos pos) {
        level.addParticle((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 5.0, 0.2, 0.2);
    }

    private void spawnHappy(Level level, BlockPos pos) {
        level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.7, (double)pos.getZ() + 0.5, 10.0, 0.2, 0.2);
    }
}

