/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.custom.vibrion;

import net.farkas.wildaside.entity.ModEntities;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.ContaminationHandler;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class SporeArrowEntity
extends AbstractArrow {
    public SporeArrowEntity(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SporeArrowEntity(Level pLevel, double pX, double pY, double pZ) {
        super(ModEntities.SPORE_ARROW.get(), pX, pY, pZ, pLevel, new ItemStack((ItemLike)ModItems.SPORE_ARROW.get()), new ItemStack((ItemLike)ModItems.SPORE_ARROW.get()));
    }

    public SporeArrowEntity(Level pLevel, LivingEntity thrower) {
        super(ModEntities.SPORE_ARROW.get(), thrower, pLevel, new ItemStack((ItemLike)ModItems.SPORE_ARROW.get()), new ItemStack((ItemLike)ModItems.SPORE_ARROW.get()));
    }

    public SporeArrowEntity(Level pLevel) {
        super(ModEntities.SPORE_ARROW.get(), pLevel);
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Entity entity = pResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (!this.level().isClientSide()) {
                ContaminationHandler.addDose((Entity)entity2, Math.round(entity2.getRandom().nextFloat() + 1.0f) * 500);
            }
        }
        super.onHitEntity(pResult);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.SPORE_ARROW.get());
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level.isClientSide && !this.inGround) {
            level.addParticle((ParticleOptions)ModParticles.VIBRION_PARTICLE.get(), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }
}

