/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.item.custom;

import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.block.custom.FallenHickoryLeavesBlock;
import net.farkas.wildaside.item.custom.FuelItem;
import net.farkas.wildaside.util.HickoryColour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HickoryLeafItem
extends FuelItem {
    private final HickoryColour colour;

    public HickoryLeafItem(Item.Properties pProperties, int burnTime, HickoryColour colour) {
        super(pProperties, burnTime);
        this.colour = colour;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        if (level.isClientSide() || pContext.getHand() == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        BlockPos pos = pContext.getClickedPos();
        Player player = pContext.getPlayer();
        InteractionHand hand = pContext.getHand();
        BlockState blockState = level.getBlockState(pos);
        if (blockState.getBlock() instanceof FallenHickoryLeavesBlock) {
            return this.addLeaf(level, pos, player, hand);
        }
        if (blockState.isFaceSturdy((BlockGetter)level, pos, Direction.UP)) {
            return this.placeLeaf(level, pos, player, hand);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult placeLeaf(Level level, BlockPos pos, Player player, InteractionHand hand) {
        BlockPos abovePos = pos.above();
        if (!level.isEmptyBlock(abovePos)) {
            if (level.getBlockState(abovePos).getBlock() instanceof FallenHickoryLeavesBlock) {
                return this.addLeaf(level, abovePos, player, hand);
            }
            return InteractionResult.PASS;
        }
        BlockState newState = (BlockState)((BlockState)((Block)ModBlocks.FALLEN_HICKORY_LEAVES.get()).defaultBlockState().setValue(FallenHickoryLeavesBlock.COLOUR, (Comparable)((Object)this.colour))).setValue((Property)FallenHickoryLeavesBlock.FACING, (Comparable)player.getDirection().getOpposite());
        level.setBlock(abovePos, newState, 3);
        this.onSuccessfulPlacement(level, abovePos, player, hand);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult addLeaf(Level level, BlockPos pos, Player player, InteractionHand hand) {
        BlockState leaves = level.getBlockState(pos);
        if (this.colour != leaves.getValue(FallenHickoryLeavesBlock.COLOUR)) {
            return InteractionResult.PASS;
        }
        int count = (Integer)leaves.getValue((Property)FallenHickoryLeavesBlock.COUNT);
        if (count >= 3) {
            return InteractionResult.PASS;
        }
        BlockState newState = (BlockState)leaves.setValue((Property)FallenHickoryLeavesBlock.COUNT, (Comparable)Integer.valueOf(count + 1));
        level.setBlock(pos, newState, 3);
        this.onSuccessfulPlacement(level, pos, player, hand);
        return InteractionResult.SUCCESS;
    }

    private void onSuccessfulPlacement(Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack item = player.getItemInHand(hand);
        level.playSound(null, pos, SoundEvents.BIG_DRIPLEAF_PLACE, SoundSource.BLOCKS, 1.0f, 1.1f);
        if (!player.isInvulnerable()) {
            item.shrink(1);
        }
    }

    public HickoryColour getColour() {
        return this.colour;
    }
}

