/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.item.custom;

import java.util.List;
import net.farkas.wildaside.util.HickoryColour;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class HickoryNutTrailMix
extends Item {
    private final HickoryColour colour;

    public HickoryNutTrailMix(Item.Properties pProperties, HickoryColour colour) {
        super(pProperties);
        this.colour = colour;
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (!pLevel.isClientSide) {
            MobEffectInstance saturation = new MobEffectInstance(MobEffects.SATURATION, 400, 0);
            Holder effect = switch (this.colour) {
                case HickoryColour.RED_GLOWING -> MobEffects.DAMAGE_BOOST;
                case HickoryColour.BROWN_GLOWING -> MobEffects.DAMAGE_RESISTANCE;
                case HickoryColour.YELLOW_GLOWING -> MobEffects.FIRE_RESISTANCE;
                case HickoryColour.GREEN_GLOWING -> MobEffects.REGENERATION;
                default -> MobEffects.SATURATION;
            };
            pLivingEntity.addEffect(saturation);
            pLivingEntity.addEffect(new MobEffectInstance(effect, 400, 0));
        }
        return super.finishUsingItem(pStack, pLevel, pLivingEntity);
    }

    public HickoryColour getColour() {
        return this.colour;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.wildaside.hickory_nut_trail_mix.tooltip"));
    }
}

