/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.network;

import net.farkas.wildaside.network.WindData;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;

public class WindSavedData
extends SavedData {
    private boolean lastRaining = false;
    private boolean lastThundering = false;
    private double windX = 0.0;
    private double windY = 0.0;
    private double windZ = 0.0;
    private float windStrength = 0.0f;

    public WindSavedData(CompoundTag tag, HolderLookup.Provider provider) {
        this.lastRaining = tag.getBoolean("lastRaining");
        this.lastThundering = tag.getBoolean("lastThundering");
        this.windX = tag.getDouble("windX");
        this.windY = tag.getDouble("windY");
        this.windZ = tag.getDouble("windZ");
        this.windStrength = tag.getFloat("windStrength");
    }

    public WindSavedData() {
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        compoundTag.putBoolean("lastRaining", this.lastRaining);
        compoundTag.putBoolean("lastThundering", this.lastThundering);
        compoundTag.putDouble("windX", this.windX);
        compoundTag.putDouble("windY", this.windY);
        compoundTag.putDouble("windZ", this.windZ);
        compoundTag.putFloat("windStrength", this.windStrength);
        return compoundTag;
    }

    public boolean wasRaining() {
        return this.lastRaining;
    }

    public boolean wasThundering() {
        return this.lastThundering;
    }

    public void setWeather(boolean raining, boolean thundering) {
        this.lastRaining = raining;
        this.lastThundering = thundering;
        this.setDirty();
    }

    public void setWind(Vec3 direction, float strength) {
        this.windX = direction.x;
        this.windY = direction.y;
        this.windZ = direction.z;
        this.windStrength = strength;
        this.setDirty();
    }

    public Vec3 getWindDirection() {
        return new Vec3(this.windX, this.windY, this.windZ);
    }

    public float getWindStrength() {
        return this.windStrength;
    }

    public WindData getWindData() {
        return new WindData(this.getWindDirection(), this.getWindStrength());
    }

    public static WindSavedData get(ServerLevel level) {
        return (WindSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WindSavedData::new, WindSavedData::new), "wildaside_weather");
    }
}

