/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.util;

import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class WeightedFlowerChoice {
    private final List<WeightedFlower> weightedFlowers;

    public WeightedFlowerChoice(List<WeightedFlower> weightedFlowers) {
        this.weightedFlowers = weightedFlowers;
    }

    public BlockState selectFlower(RandomSource random) {
        int totalWeight = 0;
        for (WeightedFlower wf : this.weightedFlowers) {
            totalWeight += wf.weight;
        }
        int choice = random.nextInt(totalWeight);
        for (WeightedFlower wf : this.weightedFlowers) {
            if ((choice -= wf.weight) >= 0) continue;
            return wf.state;
        }
        return this.weightedFlowers.get((int)0).state;
    }

    public static class WeightedFlower {
        public final int weight;
        public final BlockState state;

        public WeightedFlower(int weight, Block block) {
            this.weight = weight;
            this.state = block.defaultBlockState();
        }
    }
}

