/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen;

import java.util.EnumMap;
import java.util.List;
import java.util.stream.Stream;
import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.util.HickoryColour;
import net.farkas.wildaside.worldgen.ModConfiguredFeatures;
import net.farkas.wildaside.worldgen.ModOrePlacement;
import net.farkas.wildaside.worldgen.modifier.LargePatchNoiseModifier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import org.joml.Vector2f;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> LARGE_SUBSTILIUM_MUSHROOM = ModPlacedFeatures.registerKey("large_substilium_mushroom");
    public static final ResourceKey<PlacedFeature> VIBRION_GROWTH = ModPlacedFeatures.registerKey("vibrion_growth");
    public static final ResourceKey<PlacedFeature> VIBRION_SPOREHOLDER = ModPlacedFeatures.registerKey("vibrion_sporeholder");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_SPROUTS = ModPlacedFeatures.registerKey("substilium_sprouts");
    public static final ResourceKey<PlacedFeature> HANGING_VIBRION_VINES = ModPlacedFeatures.registerKey("hanging_vibrion_vines");
    public static final ResourceKey<PlacedFeature> HANGING_VIBRION_GEL = ModPlacedFeatures.registerKey("hanging_vibrion_gel");
    public static final ResourceKey<PlacedFeature> HANGING_LIT_VIBRION_GEL = ModPlacedFeatures.registerKey("hanging_lit_vibrion_gel");
    public static final ResourceKey<PlacedFeature> OVERGROWN_ENTORIUM_ORE = ModPlacedFeatures.registerKey("overgrown_entorium_ore");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_COAL_ORE = ModPlacedFeatures.registerKey("substilium_coal_ore");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_COPPER_ORE = ModPlacedFeatures.registerKey("substilium_copper_ore");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_COPPER_ORE_LARGE = ModPlacedFeatures.registerKey("substilium_copper_ore_large");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_LAPIS_ORE = ModPlacedFeatures.registerKey("substilium_lapis_ore");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_LAPIS_ORE_BURIED = ModPlacedFeatures.registerKey("substilium_lapis_ore_buried");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_IRON_ORE_MIDDLE = ModPlacedFeatures.registerKey("substilium_iron_ore_middle");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_IRON_ORE_SMALL = ModPlacedFeatures.registerKey("substilium_iron_ore_small");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_GOLD_ORE = ModPlacedFeatures.registerKey("substilium_gold_ore");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_GOLD_ORE_LOWER = ModPlacedFeatures.registerKey("substilium_gold_ore_lower");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_REDSTONE_ORE = ModPlacedFeatures.registerKey("substilium_redstone_ore");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_REDSTONE_ORE_LOWER = ModPlacedFeatures.registerKey("substilium_redstone_ore_lower");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_DIAMOND_ORE = ModPlacedFeatures.registerKey("substilium_diamond_ore");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_DIAMOND_ORE_LARGE = ModPlacedFeatures.registerKey("substilium_diamond_ore_large");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_DIAMOND_ORE_BURIED = ModPlacedFeatures.registerKey("substilium_diamond_ore_buried");
    public static final ResourceKey<PlacedFeature> SUBSTILIUM_EMERALD_ORE = ModPlacedFeatures.registerKey("substilium_emerald_ore");
    public static final ResourceKey<PlacedFeature> COMPRESSED_SUBSTILIUM_SOIL = ModPlacedFeatures.registerKey("compressed_substilium_soil");
    public static final ResourceKey<PlacedFeature> NATURAL_SPORE_BLASTER = ModPlacedFeatures.registerKey("natural_spore_blaster");
    public static final ResourceKey<PlacedFeature> SPOTTED_WINTERGREEN = ModPlacedFeatures.registerKey("spotted_wintergreen");
    public static final ResourceKey<PlacedFeature> PINKSTER_FLOWER = ModPlacedFeatures.registerKey("pinkster_flower");
    public static final ResourceKey<PlacedFeature> HICKORY_TREE = ModPlacedFeatures.registerKey("hickory_tree");
    public static final ResourceKey<PlacedFeature> RED_GLOWING_HICKORY_TREE = ModPlacedFeatures.registerKey("red_glowing_hickory_tree");
    public static final ResourceKey<PlacedFeature> BROWN_GLOWING_HICKORY_TREE = ModPlacedFeatures.registerKey("brown_glowing_hickory_tree");
    public static final ResourceKey<PlacedFeature> YELLOW_GLOWING_HICKORY_TREE = ModPlacedFeatures.registerKey("yellow_glowing_hickory_tree");
    public static final ResourceKey<PlacedFeature> GREEN_GLOWING_HICKORY_TREE = ModPlacedFeatures.registerKey("green_glowing_hickory_tree");
    public static final ResourceKey<PlacedFeature> HICKORY_SAPLING = ModPlacedFeatures.registerKey("hickory_sapling");
    public static final ResourceKey<PlacedFeature> RED_GLOWING_HICKORY_SAPLING = ModPlacedFeatures.registerKey("red_glowing_hickory_sapling");
    public static final ResourceKey<PlacedFeature> BROWN_GLOWING_HICKORY_SAPLING = ModPlacedFeatures.registerKey("brown_glowing_hickory_sapling");
    public static final ResourceKey<PlacedFeature> YELLOW_GLOWING_HICKORY_SAPLING = ModPlacedFeatures.registerKey("yellow_glowing_hickory_sapling");
    public static final ResourceKey<PlacedFeature> GREEN_GLOWING_HICKORY_SAPLING = ModPlacedFeatures.registerKey("green_glowing_hickory_sapling");
    public static final ResourceKey<PlacedFeature> HICKORY_BUSH = ModPlacedFeatures.registerKey("hickory_bush");
    public static final ResourceKey<PlacedFeature> RED_GLOWING_HICKORY_BUSH = ModPlacedFeatures.registerKey("red_glowing_hickory_bush");
    public static final ResourceKey<PlacedFeature> BROWN_GLOWING_HICKORY_BUSH = ModPlacedFeatures.registerKey("brown_glowing_hickory_bush");
    public static final ResourceKey<PlacedFeature> YELLOW_GLOWING_HICKORY_BUSH = ModPlacedFeatures.registerKey("yellow_glowing_hickory_bush");
    public static final ResourceKey<PlacedFeature> GREEN_GLOWING_HICKORY_BUSH = ModPlacedFeatures.registerKey("green_glowing_hickory_bush");
    public static final ResourceKey<PlacedFeature> FALLEN_HICKORY_TREE = ModPlacedFeatures.registerKey("fallen_hickory_tree");
    public static final ResourceKey<PlacedFeature> PODZOL_VEIN = ModPlacedFeatures.registerKey("podzol_vein");
    public static final EnumMap<HickoryColour, Vector2f> HICKORY_NOISES = new EnumMap(HickoryColour.class);
    public static final EnumMap<HickoryColour, ResourceKey<PlacedFeature>> HICKORY_TREES;
    public static final EnumMap<HickoryColour, ResourceKey<PlacedFeature>> HICKORY_SAPLINGS;
    public static final EnumMap<HickoryColour, ResourceKey<PlacedFeature>> HICKORY_BUSHES;

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        HeightRangePlacement vibrionHivePlacement = HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)80));
        ModPlacedFeatures.register(context, LARGE_SUBSTILIUM_MUSHROOM, configuredFeatures.getOrThrow(ModConfiguredFeatures.LARGE_SUBSTILIUM_MUSHROOM), List.of(PlacementUtils.countExtra((int)200, (float)0.5f, (int)56), InSquarePlacement.spread(), vibrionHivePlacement, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, VIBRION_GROWTH, configuredFeatures.getOrThrow(ModConfiguredFeatures.VIBRION_GROWTH), List.of(PlacementUtils.countExtra((int)128, (float)1.0f, (int)32), InSquarePlacement.spread(), vibrionHivePlacement, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, VIBRION_SPOREHOLDER, configuredFeatures.getOrThrow(ModConfiguredFeatures.VIBRION_SPOREHOLDER), List.of(PlacementUtils.countExtra((int)64, (float)0.5f, (int)32), InSquarePlacement.spread(), vibrionHivePlacement, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, SUBSTILIUM_SPROUTS, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_SPROUTS), List.of(PlacementUtils.countExtra((int)128, (float)1.0f, (int)32), InSquarePlacement.spread(), vibrionHivePlacement, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, HANGING_VIBRION_VINES, configuredFeatures.getOrThrow(ModConfiguredFeatures.HANGING_VIBRION_VINES), List.of(CountPlacement.of((int)256), InSquarePlacement.spread(), vibrionHivePlacement, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)32), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, HANGING_VIBRION_GEL, configuredFeatures.getOrThrow(ModConfiguredFeatures.HANGING_VIBRION_GEL), List.of(CountPlacement.of((int)64), InSquarePlacement.spread(), vibrionHivePlacement, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)32), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, HANGING_LIT_VIBRION_GEL, configuredFeatures.getOrThrow(ModConfiguredFeatures.HANGING_LIT_VIBRION_GEL), List.of(CountPlacement.of((int)64), InSquarePlacement.spread(), vibrionHivePlacement, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)32), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, SUBSTILIUM_COAL_ORE, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_COAL_ORE), ModOrePlacement.commonOrePlacement(20, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)192))));
        ModPlacedFeatures.register(context, SUBSTILIUM_COPPER_ORE, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_COPPER_ORE_SMALL), ModOrePlacement.commonOrePlacement(16, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-16), (VerticalAnchor)VerticalAnchor.absolute((int)112))));
        ModPlacedFeatures.register(context, SUBSTILIUM_COPPER_ORE_LARGE, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_COPPER_ORE_LARGE), ModOrePlacement.commonOrePlacement(16, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)112))));
        ModPlacedFeatures.register(context, SUBSTILIUM_LAPIS_ORE, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_LAPIS_ORE), ModOrePlacement.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-32), (VerticalAnchor)VerticalAnchor.absolute((int)64))));
        ModPlacedFeatures.register(context, SUBSTILIUM_LAPIS_ORE_BURIED, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_LAPIS_ORE_BURIED), ModOrePlacement.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)63))));
        ModPlacedFeatures.register(context, SUBSTILIUM_IRON_ORE_MIDDLE, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_IRON_ORE), ModOrePlacement.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-24), (VerticalAnchor)VerticalAnchor.absolute((int)56))));
        ModPlacedFeatures.register(context, SUBSTILIUM_IRON_ORE_SMALL, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_IRON_ORE_SMALL), ModOrePlacement.commonOrePlacement(11, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)72))));
        ModPlacedFeatures.register(context, SUBSTILIUM_GOLD_ORE, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_GOLD_ORE_BURIED), ModOrePlacement.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)32))));
        ModPlacedFeatures.register(context, SUBSTILIUM_GOLD_ORE_LOWER, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_GOLD_ORE_BURIED), ModOrePlacement.orePlacement((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)0, (int)1)), (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)-48))));
        ModPlacedFeatures.register(context, SUBSTILIUM_REDSTONE_ORE, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_REDSTONE_ORE), ModOrePlacement.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)15))));
        ModPlacedFeatures.register(context, SUBSTILIUM_REDSTONE_ORE_LOWER, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_REDSTONE_ORE), ModOrePlacement.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-32), (VerticalAnchor)VerticalAnchor.absolute((int)32))));
        ModPlacedFeatures.register(context, SUBSTILIUM_DIAMOND_ORE, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_DIAMOND_ORE_SMALL), ModOrePlacement.commonOrePlacement(7, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, SUBSTILIUM_DIAMOND_ORE_BURIED, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_DIAMOND_ORE_LARGE), ModOrePlacement.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, SUBSTILIUM_DIAMOND_ORE_LARGE, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_DIAMOND_ORE_BURIED), ModOrePlacement.commonOrePlacement(9, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, SUBSTILIUM_EMERALD_ORE, configuredFeatures.getOrThrow(ModConfiguredFeatures.SUBSTILIUM_EMERALD_ORE), ModOrePlacement.commonOrePlacement(100, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-16), (VerticalAnchor)VerticalAnchor.absolute((int)480))));
        ModPlacedFeatures.register(context, OVERGROWN_ENTORIUM_ORE, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERGROWN_ENTORIUM_ORE), ModOrePlacement.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, COMPRESSED_SUBSTILIUM_SOIL, configuredFeatures.getOrThrow(ModConfiguredFeatures.COMPRESSED_SUBSTILIUM_SOIL), ModOrePlacement.commonOrePlacement(48, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, NATURAL_SPORE_BLASTER, configuredFeatures.getOrThrow(ModConfiguredFeatures.NATURAL_SPORE_BLASTER), ModOrePlacement.commonOrePlacement(256, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, HICKORY_TREE, configuredFeatures.getOrThrow(ModConfiguredFeatures.HICKORY_TREE), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)48, (float)0.25f, (int)20), (Block)((Block)ModBlocks.HICKORY_SAPLING.get())));
        ModPlacedFeatures.register(context, HICKORY_SAPLING, configuredFeatures.getOrThrow(ModConfiguredFeatures.HICKORY_SAPLING), List.of(RarityFilter.onAverageOnceEvery((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, HICKORY_BUSH, configuredFeatures.getOrThrow(ModConfiguredFeatures.HICKORY_BUSH), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)32, (float)0.5f, (int)20)));
        for (HickoryColour colour : HickoryColour.values()) {
            if (colour == HickoryColour.HICKORY) continue;
            Vector2f noise = HICKORY_NOISES.get((Object)colour);
            ModPlacedFeatures.registerGlowingHickoryTree(context, configuredFeatures, colour, noise.x, noise.y);
            ModPlacedFeatures.registerGlowingHickoryBush(context, configuredFeatures, colour, noise.x, noise.y);
            ModPlacedFeatures.registerGlowingHickorySapling(context, configuredFeatures, colour, noise.x, noise.y);
        }
        ModPlacedFeatures.register(context, SPOTTED_WINTERGREEN, configuredFeatures.getOrThrow(ModConfiguredFeatures.SPOTTED_EVERGREEN), List.of(RarityFilter.onAverageOnceEvery((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, PINKSTER_FLOWER, configuredFeatures.getOrThrow(ModConfiguredFeatures.PINKSTER_FLOWER), List.of(RarityFilter.onAverageOnceEvery((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, FALLEN_HICKORY_TREE, configuredFeatures.getOrThrow(ModConfiguredFeatures.FALLEN_HICKORY_TREE), List.of(RarityFilter.onAverageOnceEvery((int)8), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, PODZOL_VEIN, configuredFeatures.getOrThrow(ModConfiguredFeatures.PODZOL_VEIN), ModOrePlacement.commonOrePlacement(16, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)40), (VerticalAnchor)VerticalAnchor.absolute((int)256))));
    }

    private static void registerGlowingHickoryTree(BootstrapContext<PlacedFeature> context, HolderGetter<ConfiguredFeature<?, ?>> configuredFeatures, HickoryColour colour, float minNoise, float maxNoise) {
        int count = 24;
        int extraCount = 10;
        List treeMods = VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)count, (float)0.5f, (int)extraCount), (Block)((Block)ModBlocks.HICKORY_SAPLINGS.get((Object)colour).get()));
        List<LargePatchNoiseModifier> patchMods = List.of(new LargePatchNoiseModifier(minNoise, maxNoise));
        List<PlacementModifier> allMods = Stream.concat(treeMods.stream(), patchMods.stream()).toList();
        ModPlacedFeatures.register(context, HICKORY_TREES.get((Object)colour), configuredFeatures.getOrThrow(ModConfiguredFeatures.HICKORY_TREES.get((Object)colour)), allMods);
    }

    private static void registerGlowingHickoryBush(BootstrapContext<PlacedFeature> context, HolderGetter<ConfiguredFeature<?, ?>> configuredFeatures, HickoryColour colour, float minNoise, float maxNoise) {
        int count = 14;
        int extraCount = 10;
        List bushMods = VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)count, (float)0.5f, (int)extraCount));
        List<LargePatchNoiseModifier> patchMods = List.of(new LargePatchNoiseModifier(minNoise, maxNoise));
        List<PlacementModifier> allMods = Stream.concat(bushMods.stream(), patchMods.stream()).toList();
        ModPlacedFeatures.register(context, HICKORY_BUSHES.get((Object)colour), configuredFeatures.getOrThrow(ModConfiguredFeatures.HICKORY_BUSHES.get((Object)colour)), allMods);
    }

    private static void registerGlowingHickorySapling(BootstrapContext<PlacedFeature> context, HolderGetter<ConfiguredFeature<?, ?>> configuredFeatures, HickoryColour colour, float minNoise, float maxNoise) {
        int chance = 4;
        List<BiomeFilter> saplingMods = List.of(RarityFilter.onAverageOnceEvery((int)chance), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        List<LargePatchNoiseModifier> patchMods = List.of(new LargePatchNoiseModifier(minNoise, maxNoise));
        List<PlacementModifier> allMods = Stream.concat(saplingMods.stream(), patchMods.stream()).toList();
        ModPlacedFeatures.register(context, HICKORY_SAPLINGS.get((Object)colour), configuredFeatures.getOrThrow(ModConfiguredFeatures.HICKORY_SAPLINGS.get((Object)colour)), allMods);
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wildaside", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    static {
        HICKORY_NOISES.put(HickoryColour.HICKORY, null);
        HICKORY_NOISES.put(HickoryColour.RED_GLOWING, new Vector2f(-1.0f, -0.45f));
        HICKORY_NOISES.put(HickoryColour.BROWN_GLOWING, new Vector2f(-0.5f, 0.0f));
        HICKORY_NOISES.put(HickoryColour.YELLOW_GLOWING, new Vector2f(-0.05f, 0.45f));
        HICKORY_NOISES.put(HickoryColour.GREEN_GLOWING, new Vector2f(0.4f, 1.0f));
        HICKORY_TREES = new EnumMap(HickoryColour.class);
        HICKORY_TREES.put(HickoryColour.HICKORY, HICKORY_TREE);
        HICKORY_TREES.put(HickoryColour.RED_GLOWING, RED_GLOWING_HICKORY_TREE);
        HICKORY_TREES.put(HickoryColour.BROWN_GLOWING, BROWN_GLOWING_HICKORY_TREE);
        HICKORY_TREES.put(HickoryColour.YELLOW_GLOWING, YELLOW_GLOWING_HICKORY_TREE);
        HICKORY_TREES.put(HickoryColour.GREEN_GLOWING, GREEN_GLOWING_HICKORY_TREE);
        HICKORY_SAPLINGS = new EnumMap(HickoryColour.class);
        HICKORY_SAPLINGS.put(HickoryColour.HICKORY, HICKORY_SAPLING);
        HICKORY_SAPLINGS.put(HickoryColour.RED_GLOWING, RED_GLOWING_HICKORY_SAPLING);
        HICKORY_SAPLINGS.put(HickoryColour.BROWN_GLOWING, BROWN_GLOWING_HICKORY_SAPLING);
        HICKORY_SAPLINGS.put(HickoryColour.YELLOW_GLOWING, YELLOW_GLOWING_HICKORY_SAPLING);
        HICKORY_SAPLINGS.put(HickoryColour.GREEN_GLOWING, GREEN_GLOWING_HICKORY_SAPLING);
        HICKORY_BUSHES = new EnumMap(HickoryColour.class);
        HICKORY_BUSHES.put(HickoryColour.HICKORY, HICKORY_BUSH);
        HICKORY_BUSHES.put(HickoryColour.RED_GLOWING, RED_GLOWING_HICKORY_BUSH);
        HICKORY_BUSHES.put(HickoryColour.BROWN_GLOWING, BROWN_GLOWING_HICKORY_BUSH);
        HICKORY_BUSHES.put(HickoryColour.YELLOW_GLOWING, YELLOW_GLOWING_HICKORY_BUSH);
        HICKORY_BUSHES.put(HickoryColour.GREEN_GLOWING, GREEN_GLOWING_HICKORY_BUSH);
    }
}

