/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import net.farkas.wildaside.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class FallenHickoryTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public FallenHickoryTreeFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        int maxLength = 10;
        int minLength = 3;
        int available = 0;
        for (int i = 0; i < 10; ++i) {
            BlockPos pos = origin.relative(dir, i);
            BlockPos below = pos.below();
            if (!world.isEmptyBlock(pos) && world.getBlockState(pos).isSolid() || !world.getBlockState(below).isFaceSturdy((BlockGetter)world, below, Direction.UP)) break;
            ++available;
        }
        if (available <= 3) {
            return false;
        }
        int length = random.nextInt(3, available);
        BlockState log = (BlockState)((Block)ModBlocks.HICKORY_LOG.get()).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis());
        int skipPlace = random.nextInt(length);
        for (int i = 0; i < length; ++i) {
            BlockPos trunkPos = origin.relative(dir, i);
            if (random.nextFloat() < 0.5f && i == skipPlace) continue;
            world.setBlock(trunkPos, log, 3);
        }
        return true;
    }
}

