/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.feature.tree.hickory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.farkas.wildaside.worldgen.feature.ModFoliagePlacers;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import org.joml.Math;

public class HickoryTreeFoliagePlacer
extends FoliagePlacer {
    private final int height;
    public static final Codec<HickoryTreeFoliagePlacer> CODEC = RecordCodecBuilder.create(hickoryFoliagePlacerInstance -> HickoryTreeFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)hickoryFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)30).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)hickoryFoliagePlacerInstance, HickoryTreeFoliagePlacer::new));

    public HickoryTreeFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    protected FoliagePlacerType<?> type() {
        return ModFoliagePlacers.HICKORY_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        int breakPoint = Math.round((float)((float)pFoliageHeight * 0.35f));
        for (int i = -pFoliageHeight / 6; i < breakPoint; ++i) {
            int c = i + pFoliageHeight / 6;
            int radius = Math.round((float)((float)c / (float)breakPoint * (float)pFoliageRadius));
            if (radius > 1) {
                int xOff = pRandom.nextIntBetweenInclusive(-1, 1);
                int zOff = pRandom.nextIntBetweenInclusive(-1, 1);
                this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().below(i), radius - 1, 0, pAttachment.doubleTrunk());
                this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().below(i).offset(xOff, 0, zOff), radius - 1, 0, pAttachment.doubleTrunk());
                this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().below(i).offset(-xOff, 0, -zOff), radius - 2, 0, pAttachment.doubleTrunk());
                continue;
            }
            this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().below(i), radius, 0, pAttachment.doubleTrunk());
        }
        int m = pFoliageHeight - breakPoint;
        for (int i = breakPoint; i < pFoliageHeight; ++i) {
            int c = pFoliageHeight - i;
            int radius = Math.round((float)((float)c / (float)m * (float)pFoliageRadius));
            if (radius > 1) {
                int xOff = pRandom.nextIntBetweenInclusive(-1, 1);
                int zOff = pRandom.nextIntBetweenInclusive(-1, 1);
                this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().below(i).offset(xOff, 0, zOff), radius - 1, 0, pAttachment.doubleTrunk());
                this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().below(i).offset(-xOff, 0, -zOff), radius - 1, 0, pAttachment.doubleTrunk());
            } else {
                this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().below(i), radius, 0, pAttachment.doubleTrunk());
            }
            this.placeLeavesRowWithHangingLeavesBelow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().below(i), radius, 0, pAttachment.doubleTrunk(), 0.5f, 0.25f);
        }
    }

    public int foliageHeight(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return this.height;
    }

    protected boolean shouldSkipLocation(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return (pLocalX == pRange && pLocalZ == pRange && pRange > 0 || (pLocalX == pRange || pLocalZ == pRange) && pRange > 1) && pRandom.nextFloat() > 0.5f;
    }
}

