/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom;

import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.block.custom.FallenHickoryLeavesBlock;
import net.farkas.wildaside.config.Config;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.GlowingHickoryLightUtil;
import net.farkas.wildaside.util.HickoryColour;
import net.farkas.wildaside.util.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class GlowingHickoryLeavesBlock
extends LeavesBlock {
    private static final int MIN_LIGHT = 0;
    private static final int MAX_LIGHT = 7;
    public static final IntegerProperty LIGHT = IntegerProperty.m_61631_((String)"light", (int)0, (int)7);
    public static final BooleanProperty FIXED_LIGHTING = BooleanProperty.m_61465_((String)"fixed_lighting");
    private final HickoryColour colour;

    public GlowingHickoryLeavesBlock(BlockBehaviour.Properties pProperties, HickoryColour colour) {
        super(pProperties.m_60953_(s -> (Integer)s.m_61143_((Property)LIGHT)));
        this.colour = colour;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(0))).m_61124_((Property)FIXED_LIGHTING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54418_, f_54419_, f_221367_, LIGHT, FIXED_LIGHTING});
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (!pLevel.f_46443_) {
            pLevel.m_186460_(pPos, (Block)this, 0);
        }
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_ || pHand == InteractionHand.OFF_HAND || ((Boolean)pState.m_61143_((Property)FIXED_LIGHTING)).booleanValue()) {
            return InteractionResult.PASS;
        }
        ItemStack playerItem = pPlayer.m_21120_(pHand);
        if (playerItem.m_41720_().equals(ModItems.VIBRION.get())) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)FIXED_LIGHTING, (Comparable)Boolean.valueOf(true)), 3);
            pLevel.m_5594_(null, pPos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
            pPlayer.m_6674_(pHand);
            if (!pPlayer.m_20147_()) {
                playerItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_213897_(pState, pLevel, pPos, pRandom);
        if (pLevel.m_5776_() || ((Boolean)pState.m_61143_((Property)FIXED_LIGHTING)).booleanValue() || !((Boolean)Config.GLOWING_HICKORY_TICK.get()).booleanValue()) {
            return;
        }
        int time = (int)pLevel.m_8044_();
        int currentLight = (Integer)pState.m_61143_((Property)LIGHT);
        int newLight = GlowingHickoryLightUtil.getLight(time, 0, 7);
        if (newLight != currentLight) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(newLight)));
        }
        pLevel.m_186460_(pPos, (Block)this, 100);
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_214162_(pState, pLevel, pPos, pRandom);
        if (pLevel.m_8055_(pPos.m_7495_()).m_60783_((BlockGetter)pLevel, pPos.m_7495_(), Direction.UP)) {
            return;
        }
        SimpleParticleType particle = (SimpleParticleType)ModParticles.HICKORY_PARTICLES.get((Object)this.colour).get();
        if ((double)pRandom.m_188501_() < 0.025) {
            ParticleUtils.spawnHickoryParticles(pLevel, pPos, pRandom, particle);
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((double)pRandom.m_188501_() < 0.02) {
            this.spawnNewFallenLeaves((Level)pLevel, pPos, pRandom);
        }
        super.m_213898_(pState, pLevel, pPos, pRandom);
    }

    private void spawnNewFallenLeaves(Level level, BlockPos pPos, RandomSource random) {
        if (level.f_46443_) {
            return;
        }
        int x = pPos.m_123341_() + random.m_216332_(-2, 2);
        int z = pPos.m_123343_() + random.m_216332_(-2, 2);
        int groundY = -100;
        for (int y = pPos.m_123342_(); y >= -64; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!level.m_8055_(pos).m_60783_((BlockGetter)level, pos, Direction.UP)) continue;
            BlockState aboveState = level.m_8055_(pos.m_7494_());
            if (!aboveState.m_60795_() && !(aboveState.m_60734_() instanceof FallenHickoryLeavesBlock)) break;
            groundY = y;
            break;
        }
        if (groundY > -64) {
            Direction direction;
            BlockPos target = new BlockPos(x, groundY + 1, z);
            BlockState state = level.m_8055_(target);
            int count = 1;
            if (state.m_60734_() instanceof FallenHickoryLeavesBlock) {
                if (state.m_61143_(FallenHickoryLeavesBlock.COLOUR) != this.colour) {
                    return;
                }
                count = Math.min((Integer)level.m_8055_(target).m_61143_((Property)FallenHickoryLeavesBlock.COUNT) + 1, 3);
                direction = (Direction)level.m_8055_(target).m_61143_((Property)FallenHickoryLeavesBlock.FACING);
            } else {
                direction = Direction.Plane.HORIZONTAL.m_235690_(random);
            }
            BlockState leafSt = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.FALLEN_HICKORY_LEAVES.get()).m_49966_().m_61124_((Property)FallenHickoryLeavesBlock.COUNT, (Comparable)Integer.valueOf(count))).m_61124_(FallenHickoryLeavesBlock.COLOUR, (Comparable)((Object)this.colour))).m_61124_((Property)FallenHickoryLeavesBlock.FACING, (Comparable)direction);
            level.m_7731_(target, leafSt, 3);
        }
    }

    public boolean m_6724_(BlockState pState) {
        return true;
    }
}

