/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom;

import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.block.custom.FallenHickoryLeavesBlock;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.HickoryColour;
import net.farkas.wildaside.util.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HickoryLeavesBlock
extends LeavesBlock {
    public HickoryLeavesBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_214162_(pState, pLevel, pPos, pRandom);
        if (pLevel.m_8055_(pPos.m_7495_()).m_60783_((BlockGetter)pLevel, pPos.m_7495_(), Direction.UP)) {
            return;
        }
        SimpleParticleType particle = (SimpleParticleType)ModParticles.HICKORY_LEAF_PARTICLE.get();
        if ((double)pRandom.m_188501_() < 0.025) {
            ParticleUtils.spawnHickoryParticles(pLevel, pPos, pRandom, particle);
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((double)pRandom.m_188501_() < 0.02) {
            this.spawnNewFallenLeaves((Level)pLevel, pPos, pRandom);
        }
        super.m_213898_(pState, pLevel, pPos, pRandom);
    }

    private void spawnNewFallenLeaves(Level level, BlockPos pPos, RandomSource random) {
        if (level.f_46443_) {
            return;
        }
        int x = pPos.m_123341_() + random.m_216332_(-2, 2);
        int z = pPos.m_123343_() + random.m_216332_(-2, 2);
        int groundY = -100;
        for (int y = pPos.m_123342_(); y >= -64; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!level.m_8055_(pos).m_60783_((BlockGetter)level, pos, Direction.UP)) continue;
            BlockState aboveState = level.m_8055_(pos.m_7494_());
            if (!aboveState.m_60795_() && !(aboveState.m_60734_() instanceof FallenHickoryLeavesBlock)) break;
            groundY = y;
            break;
        }
        if (groundY > -64) {
            Direction direction;
            BlockPos target = new BlockPos(x, groundY + 1, z);
            BlockState state = level.m_8055_(target);
            int count = 1;
            if (state.m_60734_() instanceof FallenHickoryLeavesBlock) {
                if (state.m_61143_(FallenHickoryLeavesBlock.COLOUR) != HickoryColour.HICKORY) {
                    return;
                }
                count = Math.min((Integer)level.m_8055_(target).m_61143_((Property)FallenHickoryLeavesBlock.COUNT) + 1, 3);
                direction = (Direction)level.m_8055_(target).m_61143_((Property)FallenHickoryLeavesBlock.FACING);
            } else {
                direction = Direction.Plane.HORIZONTAL.m_235690_(random);
            }
            BlockState leafSt = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.FALLEN_HICKORY_LEAVES.get()).m_49966_().m_61124_((Property)FallenHickoryLeavesBlock.COUNT, (Comparable)Integer.valueOf(count))).m_61124_(FallenHickoryLeavesBlock.COLOUR, (Comparable)((Object)HickoryColour.HICKORY))).m_61124_((Property)FallenHickoryLeavesBlock.FACING, (Comparable)direction);
            level.m_7731_(target, leafSt, 3);
        }
    }

    public boolean m_6724_(BlockState pState) {
        return true;
    }
}

