/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom.vibrion;

import java.util.List;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.ContaminationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Sporeholder
extends SaplingBlock {
    public Sporeholder(AbstractTreeGrower pTreeGrower, BlockBehaviour.Properties pProperties) {
        super(pTreeGrower, pProperties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(world, pos);
        return Sporeholder.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0).m_83216_(offset.f_82479_, 0.0, offset.f_82481_);
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.m_7892_(pState, pLevel, pPos, pEntity);
        pLevel.m_7106_((ParticleOptions)ModParticles.VIBRION_PARTICLE.get(), (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_(), (double)pPos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        if (!pLevel.m_5776_()) {
            ContaminationHandler.addDose(pEntity, 40);
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        if (!pLevel.m_5776_()) {
            this.applySporeCloud((ServerLevel)pLevel, pPos);
        }
    }

    private void applySporeCloud(ServerLevel level, BlockPos center) {
        int radius = 2;
        RandomSource rand = level.m_213780_();
        SimpleParticleType particle = (SimpleParticleType)ModParticles.VIBRION_PARTICLE.get();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (dx * dx + dy * dy + dz * dz > radius * radius) continue;
                    for (int i = 0; i < 3; ++i) {
                        double x = (double)center.m_123341_() + 0.5 + (double)dx + (rand.m_188500_() - 0.5);
                        double y = (double)center.m_123342_() + 0.5 + (double)dy + (rand.m_188500_() - 0.5);
                        double z = (double)center.m_123343_() + 0.5 + (double)dz + (rand.m_188500_() - 0.5);
                        level.m_8767_((ParticleOptions)particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        AABB box = new AABB(center).m_82400_((double)radius);
        List list = level.m_6443_(LivingEntity.class, box, e -> !e.m_5833_());
        for (LivingEntity entity : list) {
            ContaminationHandler.addDose((Entity)entity, 1000 + rand.m_216339_(0, 1000));
            level.m_8767_((ParticleOptions)particle, entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), 5, 0.2, 0.2, 0.2, 0.01);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((double)random.m_188501_() < 0.5) {
            return;
        }
        level.m_7106_((ParticleOptions)ModParticles.VIBRION_PARTICLE.get(), (double)((float)pos.m_123341_() + random.m_188501_()), (double)((float)pos.m_123342_() + random.m_188501_() / 5.0f), (double)((float)pos.m_123343_() + random.m_188501_()), 0.0, 0.0, 0.0);
    }
}

