/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.entity;

import java.util.List;
import net.farkas.wildaside.block.custom.vibrion.WindBlaster;
import net.farkas.wildaside.block.entity.BlasterBlockEntity;
import net.farkas.wildaside.block.entity.ModBlockEntities;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.BlasterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WindBlasterBlockEntity
extends BlasterBlockEntity {
    private static final int MAX_RANGE = 15;
    private static final double BASE_FORCE = 0.15;
    private BlockPos previousPos = BlockPos.f_121853_;
    private int blocksTraveled = 0;

    public WindBlasterBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.WIND_BLASTER.get(), pos, state);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
    }

    public void tickServer(Level level, BlockPos origin, BlockState oldState) {
        double particleInterval;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)WindBlaster.FACING);
        Direction back = facing.m_122424_();
        int rangeSignal = world.m_277185_(this.f_58858_.m_121945_(back), back);
        int strength = 1;
        for (Direction dir : Direction.values()) {
            if (dir == back) continue;
            strength = Math.max(strength, world.m_277185_(this.f_58858_.m_121945_(dir), dir));
        }
        if (rangeSignal <= 0) {
            return;
        }
        int range = Mth.m_14045_((int)rangeSignal, (int)1, (int)15);
        double force = 0.15 * ((double)strength / 15.0);
        RandomSource rand = world.f_46441_;
        Vec3 start = Vec3.m_82512_((Vec3i)this.f_58858_);
        double step = 0.1;
        double nextParticle = particleInterval = 0.7;
        for (double traveled = 0.8; traveled <= (double)range; traveled += step) {
            Vec3 sample = start.m_82520_((double)facing.m_122429_() * traveled, (double)facing.m_122430_() * traveled, (double)facing.m_122431_() * traveled);
            BlockPos samplePos = BlockPos.m_274446_((Position)sample);
            BlockState state = world.m_8055_(samplePos);
            if (this.previousPos != samplePos) {
                this.previousPos = samplePos;
                if (this.shouldBreakNext) {
                    this.shouldBreakNext = false;
                    break;
                }
            }
            if (state.m_60838_((BlockGetter)world, samplePos)) break;
            if (!BlasterUtils.canTraverse(facing, state, oldState, this)) {
                this.blocksTraveled = Math.abs(origin.m_123341_() - samplePos.m_123341_()) + Math.abs(origin.m_123342_() - samplePos.m_123342_()) + Math.abs(origin.m_123343_() - samplePos.m_123343_());
                if (strength - this.blocksTraveled < 7) break;
                BlockState openableBlockState = level.m_8055_(samplePos);
                if (openableBlockState.m_61138_((Property)BlockStateProperties.f_61446_)) {
                    level.m_7731_(samplePos, (BlockState)openableBlockState.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf((Boolean)openableBlockState.m_61143_((Property)DoorBlock.f_52727_) == false)), 3);
                    this.shouldBreakNext = false;
                }
            }
            if (traveled >= nextParticle) {
                nextParticle += particleInterval;
                float density = (float)((0.2 + (double)strength / 15.0) * Math.exp(-0.3 * traveled));
                if (rand.m_188501_() < density) {
                    double radius = 0.25 + 0.1 * ((double)strength / 15.0);
                    double offsetX = (rand.m_188500_() - 0.5) * 2.0 * radius;
                    double offsetY = (rand.m_188500_() - 0.5) * 2.0 * radius;
                    double offsetZ = (rand.m_188500_() - 0.5) * 2.0 * radius;
                    if (facing.m_122434_() == Direction.Axis.X) {
                        offsetX = 0.0;
                    } else if (facing.m_122434_() == Direction.Axis.Y) {
                        offsetY = 0.0;
                    } else {
                        offsetZ = 0.0;
                    }
                    Vec3 particlePos = sample.m_82520_(offsetX, offsetY, offsetZ);
                    double speed = 0.05 + 0.15 * (force / 0.15);
                    if (rand.m_188501_() < 0.8f) {
                        world.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.WIND_PARTICLE.get()), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, (double)facing.m_122429_() * speed, (double)facing.m_122430_() * speed, (double)facing.m_122431_() * speed, 0.0);
                    }
                    if (rand.m_188501_() < 0.2f) {
                        world.m_8767_((ParticleOptions)ParticleTypes.f_123759_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, (double)facing.m_122429_() * 0.02, (double)facing.m_122430_() * 0.02, (double)facing.m_122431_() * 0.02, 0.0);
                    }
                }
            }
            double falloff = Math.exp(-0.25 * traveled);
            double appliedForce = force * falloff;
            AABB box = new AABB(samplePos).m_82400_(-0.05);
            List entities = world.m_6249_((Entity)null, box, e -> true);
            for (Entity e2 : entities) {
                if (e2 instanceof ArmorStand || this.isHeavyEntity(e2)) continue;
                Vec3 velocity = e2.m_20184_();
                if (velocity.f_82480_ < -0.08 && facing.m_122430_() > 0) {
                    double fallSpeed = Math.abs(velocity.f_82480_);
                    double lift = Math.min(fallSpeed * 0.25 * ((double)strength / 15.0), 0.12);
                    velocity = velocity.m_82520_(0.0, lift, 0.0);
                }
                Vec3 push = new Vec3((double)facing.m_122429_(), (double)facing.m_122430_(), (double)facing.m_122431_());
                velocity = velocity.m_82549_(push.m_82490_(appliedForce));
                double maxSpeed = 1.5;
                double hor = Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
                if (hor > maxSpeed) {
                    double scale = maxSpeed / hor;
                    velocity = new Vec3(velocity.f_82479_ * scale, velocity.f_82480_, velocity.f_82481_ * scale);
                }
                e2.m_20256_(velocity);
                e2.f_19864_ = true;
            }
        }
    }

    private boolean isHeavyEntity(Entity e) {
        return e instanceof IronGolem || e instanceof Ravager || e instanceof WitherBoss || e instanceof EnderDragon;
    }
}

