/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.effect.custom;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.farkas.wildaside.effect.ModMobEffects;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.AdvancementHandler;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wildaside", bus=Mod.EventBusSubscriber.Bus.FORGE)
class LifestealHandler {
    private static final List<Task> TASKS = new LinkedList<Task>();

    LifestealHandler() {
    }

    @SubscribeEvent
    public static void applyLifesteal(LivingHurtEvent event) {
        DamageSource src = event.getSource();
        Entity entity = src.m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        MobEffectInstance lifesteal = attacker.m_21124_((MobEffect)ModMobEffects.LIFESTEAL.get());
        if (lifesteal == null) {
            return;
        }
        float perc = (float)(lifesteal.m_19564_() + 1) / 10.0f;
        float max = (float)(lifesteal.m_19564_() + 1) * 3.0f;
        float heal = event.getAmount() * perc;
        if (heal > max) {
            heal = max;
        }
        LivingEntity target = event.getEntity();
        Level level = attacker.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            double dist = attacker.m_20270_((Entity)target);
            int delay = Mth.m_14165_((double)(dist * 4.0));
            TASKS.add(new Task(lvl, attacker.m_20148_(), target.m_20148_(), heal, delay));
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Task> it = TASKS.iterator();
        while (it.hasNext()) {
            LivingEntity a;
            Entity target;
            Task t;
            block7: {
                block6: {
                    t = it.next();
                    Entity attacker = t.level.m_8791_(t.attackerId);
                    target = t.level.m_8791_(t.targetId);
                    if (!(attacker instanceof LivingEntity)) break block6;
                    a = (LivingEntity)attacker;
                    if (target instanceof LivingEntity) break block7;
                }
                it.remove();
                continue;
            }
            LivingEntity b = (LivingEntity)target;
            double ax = a.m_20185_();
            double ay = a.m_20186_() + (double)a.m_20206_() * 0.5;
            double az = a.m_20189_();
            double tx = b.m_20185_();
            double ty = b.m_20186_() + (double)b.m_20206_() * 0.5;
            double tz = b.m_20189_();
            double prog = (double)t.ticksElapsed / (double)t.totalTicks;
            double px = Mth.m_14139_((double)prog, (double)tx, (double)ax);
            double py = Mth.m_14139_((double)prog, (double)ty, (double)ay);
            double pz = Mth.m_14139_((double)prog, (double)tz, (double)az);
            t.level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.LIFESTEAL_PARTICLE.get()), px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
            ++t.ticksElapsed;
            if (t.ticksElapsed < t.totalTicks) continue;
            if (a instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)a;
                AdvancementHandler.givePlayerAdvancement((Entity)serverPlayer, "life_leech");
            }
            a.m_5634_(t.healAmount);
            it.remove();
        }
    }

    private static class Task {
        final ServerLevel level;
        final UUID attackerId;
        final UUID targetId;
        final float healAmount;
        final int totalTicks;
        int ticksElapsed = 0;

        Task(ServerLevel level, UUID attackerId, UUID targetId, float healAmount, int totalTicks) {
            this.level = level;
            this.attackerId = attackerId;
            this.targetId = targetId;
            this.healAmount = healAmount;
            this.totalTicks = totalTicks;
        }
    }
}

