/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.custom.hickory;

import net.farkas.wildaside.entity.ModEntities;
import net.farkas.wildaside.entity.custom.hickory.HickoryTreantEntity;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.util.HickoryColour;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class HickoryLeafProjectile
extends ThrowableItemProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<Integer> COLOUR = SynchedEntityData.m_135353_(HickoryLeafProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int phase = 0;

    public HickoryLeafProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public HickoryLeafProjectile(Level world, LivingEntity shooter, HickoryColour colour) {
        super((EntityType)ModEntities.HICKORY_LEAF_PROJECTILE.get(), shooter, world);
        this.f_19804_.m_135381_(COLOUR, (Object)colour.ordinal());
        if (shooter instanceof HickoryTreantEntity) {
            HickoryTreantEntity hickoryTreant = (HickoryTreantEntity)shooter;
            this.phase = hickoryTreant.getPhase();
        }
    }

    protected Item m_7881_() {
        return (Item)ModItems.HICKORY_LEAF.get();
    }

    public ItemStack m_7846_() {
        return switch (this.getColour()) {
            case HickoryColour.RED_GLOWING -> new ItemStack((ItemLike)ModItems.RED_GLOWING_HICKORY_LEAF.get());
            case HickoryColour.BROWN_GLOWING -> new ItemStack((ItemLike)ModItems.BROWN_GLOWING_HICKORY_LEAF.get());
            case HickoryColour.YELLOW_GLOWING -> new ItemStack((ItemLike)ModItems.YELLOW_GLOWING_HICKORY_LEAF.get());
            case HickoryColour.GREEN_GLOWING -> new ItemStack((ItemLike)ModItems.GREEN_GLOWING_HICKORY_LEAF.get());
            default -> new ItemStack((ItemLike)ModItems.HICKORY_LEAF.get());
        };
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19602_, 1, 0, false, false));
            switch (this.getColour()) {
                case RED_GLOWING: {
                    target.m_20254_(4 + this.phase);
                    break;
                }
                case BROWN_GLOWING: {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, this.phase - 1));
                    break;
                }
                case YELLOW_GLOWING: {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100, 0));
                    break;
                }
                case GREEN_GLOWING: {
                    this.healEffect();
                    break;
                }
            }
        }
        this.m_146870_();
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.m_146870_();
    }

    private void healEffect() {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)entity;
            shooter.m_5634_((float)this.phase);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOUR, (Object)HickoryColour.HICKORY.ordinal());
    }

    private HickoryColour getColour() {
        int id = (Integer)this.f_19804_.m_135370_(COLOUR);
        return HickoryColour.values()[Mth.m_14045_((int)id, (int)0, (int)(HickoryColour.values().length - 1))];
    }
}

