/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.custom.vibrion;

import java.util.List;
import net.farkas.wildaside.entity.ModEntities;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.AdvancementHandler;
import net.farkas.wildaside.util.ContaminationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class SporeBombEntity
extends ThrowableItemProjectile {
    private final float charge;

    public SporeBombEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.charge = this.m_9236_().f_46441_.m_188501_();
    }

    public SporeBombEntity(Level pLevel, LivingEntity livingEntity, float charge) {
        super((EntityType)ModEntities.SPORE_BOMB.get(), livingEntity, pLevel);
        this.charge = charge;
    }

    public SporeBombEntity(Level pLevel, double pX, double pY, double pZ) {
        super((EntityType)ModEntities.SPORE_BOMB.get(), pX, pY, pZ, pLevel);
        this.charge = this.m_9236_().f_46441_.m_188501_();
    }

    public SporeBombEntity(Level pLevel) {
        super((EntityType)ModEntities.SPORE_BOMB.get(), pLevel);
        this.charge = this.m_9236_().f_46441_.m_188501_();
    }

    protected Item m_7881_() {
        return (Item)ModItems.SPORE_BOMB.get();
    }

    protected void m_5790_(EntityHitResult pResult) {
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            pResult.m_82443_().m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 2.0f);
            this.applySporeCloud((ServerLevel)level, pResult.m_82443_().m_20183_(), this.charge);
            this.m_146870_();
        }
        super.m_5790_(pResult);
    }

    protected void m_8060_(BlockHitResult pResult) {
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            level.m_7605_((Entity)this, (byte)3);
            BlockPos position = this.m_20183_();
            this.applySporeCloud((ServerLevel)level, position, this.charge);
        }
        super.m_8060_(pResult);
        this.m_146870_();
    }

    private void applySporeCloud(ServerLevel level, BlockPos center, float charge) {
        int radius = Mth.m_14167_((float)(1.0f + charge * 4.0f));
        RandomSource random = level.m_213780_();
        SimpleParticleType particle = (SimpleParticleType)ModParticles.VIBRION_PARTICLE.get();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (dx * dx + dy * dy + dz * dz > radius * radius) continue;
                    for (int i = 0; i < 3; ++i) {
                        double x = (double)center.m_123341_() + 0.5 + (double)dx + (random.m_188500_() - 0.5);
                        double y = (double)center.m_123342_() + 0.5 + (double)dy + (random.m_188500_() - 0.5);
                        double z = (double)center.m_123343_() + 0.5 + (double)dz + (random.m_188500_() - 0.5);
                        level.m_8767_((ParticleOptions)particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        AABB box = new AABB(center).m_82400_((double)radius);
        List list = level.m_6443_(LivingEntity.class, box, e -> !e.m_5833_());
        int entityCount = 0;
        for (LivingEntity entity : list) {
            ++entityCount;
            ContaminationHandler.addDose((Entity)entity, Math.round((1.0f + charge / 2.0f) * 1000.0f));
            level.m_8767_((ParticleOptions)particle, entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), 5, 0.2, 0.2, 0.2, 0.01);
        }
        if (entityCount >= 5) {
            AdvancementHandler.givePlayerAdvancement(this.m_19749_(), "weapons_of_mass_infection");
        }
    }
}

