/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.util;

import net.farkas.wildaside.network.NetworkHandler;
import net.farkas.wildaside.network.WindData;
import net.farkas.wildaside.network.WindSavedData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class WindManager {
    private static final float RAIN_MULTIPLIER = 2.5f;
    private static final float THUNDER_MULTIPLIER = 5.0f;
    private static Vec3 direction = new Vec3(0.01, 0.0, 0.01);
    private static float strength = 0.1f;

    public static void setWind(Vec3 dir, float s) {
        direction = dir.m_82541_();
        strength = s;
        NetworkHandler.sendWindUpdateToAll(direction, strength);
    }

    public static void setWind(WindData windData) {
        direction = windData.direction().m_82541_();
        strength = windData.strength();
        NetworkHandler.sendWindUpdateToAll(direction, strength);
    }

    public static Vec3 getDirection() {
        return direction;
    }

    public static float getStrength() {
        return strength;
    }

    public static WindData getWindData() {
        return new WindData(WindManager.getDirection(), WindManager.getStrength());
    }

    public static WindData calculateAndSetWind(ServerLevel serverLevel, boolean forceRecalc) {
        RandomSource randomSource = serverLevel.f_46441_;
        WindSavedData windSavedData = WindSavedData.get(serverLevel);
        boolean raining = serverLevel.m_46471_();
        boolean thundering = serverLevel.m_46470_();
        float correction = forceRecalc ? WindManager.getWeatherMultiplier(raining, thundering) : WindManager.getWindCorrection(windSavedData.wasRaining(), windSavedData.wasThundering(), raining, thundering);
        double angle = randomSource.m_188500_() * 2.0 * Math.PI;
        Vec3 newDir = new Vec3(Math.cos(angle), (double)((randomSource.m_188501_() - 0.5f) * 0.02f), Math.sin(angle)).m_82490_((double)correction);
        float strength = (0.03f + randomSource.m_188501_() * 0.1f) * correction;
        WindManager.setWind(newDir, strength);
        windSavedData.setWeather(raining, thundering);
        windSavedData.setWind(newDir, strength);
        return new WindData(newDir, strength);
    }

    private static float getWeatherMultiplier(boolean raining, boolean thundering) {
        if (thundering) {
            return 5.0f;
        }
        if (raining) {
            return 2.5f;
        }
        return 1.0f;
    }

    public static float getWindCorrection(boolean oldRaining, boolean oldThundering, boolean newRaining, boolean newThundering) {
        float oldMultiplier = 1.0f;
        if (oldRaining) {
            oldMultiplier = 2.5f;
        }
        if (oldThundering) {
            oldMultiplier = 5.0f;
        }
        float newMultiplier = 1.0f;
        if (newRaining) {
            newMultiplier = 2.5f;
        }
        if (newThundering) {
            newMultiplier = 5.0f;
        }
        return newMultiplier / oldMultiplier;
    }
}

