/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.farkas.wildaside.util.LargeMushroomCapShape;
import net.farkas.wildaside.worldgen.feature.configuration.LargeMushroomConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.Vec3;
import org.joml.SimplexNoise;

public class LargeMushroomFeature
extends Feature<LargeMushroomConfiguration> {
    public LargeMushroomFeature(Codec<LargeMushroomConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<LargeMushroomConfiguration> ctx) {
        LargeMushroomConfiguration config;
        WorldGenLevel level = ctx.m_159774_();
        RandomSource random = ctx.m_225041_();
        BlockPos origin = ctx.m_159777_();
        BlockPos ground = this.findGround((LevelAccessor)level, origin, config = (LargeMushroomConfiguration)ctx.m_159778_());
        if (ground == null) {
            return false;
        }
        int clearance = this.findCeilingDistance(level, ground.m_7494_());
        if (clearance < config.minHeight()) {
            return false;
        }
        int height = Mth.m_14045_((int)random.m_216332_(config.minHeight(), config.maxHeight()), (int)config.minHeight(), (int)config.maxHeight());
        height = Math.min(height, clearance - 2);
        Vec3 leanDir = this.calculateLeanDirection(level, ground);
        leanDir = this.exaggerateLean(level, ground, leanDir);
        if (!this.hasEnoughSpace((LevelAccessor)level, ground.m_7494_(), height, leanDir)) {
            return false;
        }
        this.generateStem((LevelAccessor)level, ground.m_7494_(), height, leanDir, config, random);
        LargeMushroomCapShape shape = LargeMushroomCapShape.pickWeightedShape(random, config.capShapeWeights());
        this.generateCap((LevelAccessor)level, ground.m_6630_(height), leanDir, config, random, height, shape);
        return true;
    }

    private BlockPos findGround(LevelAccessor level, BlockPos start, LargeMushroomConfiguration config) {
        BlockPos.MutableBlockPos pos = start.m_122032_();
        for (int dy = 0; dy < 8; ++dy) {
            BlockPos below = pos.m_6625_(dy);
            BlockState stateBelow = level.m_8055_(below);
            for (BlockStateProvider valid : config.validBaseBlocks()) {
                if (!stateBelow.m_60713_(valid.m_213972_(level.m_213780_(), (BlockPos)pos).m_60734_()) || !level.m_46859_(below.m_7494_())) continue;
                return below.m_7494_();
            }
        }
        return null;
    }

    private int findCeilingDistance(WorldGenLevel level, BlockPos pos) {
        int dist = 0;
        BlockPos.MutableBlockPos cursor = pos.m_122032_();
        while (cursor.m_123342_() < level.m_151558_()) {
            cursor.m_122184_(0, 1, 0);
            if (!level.m_46859_((BlockPos)cursor)) break;
            ++dist;
        }
        return dist;
    }

    private Vec3 calculateLeanDirection(WorldGenLevel level, BlockPos base) {
        int radius = 4;
        Vec3 lean = Vec3.f_82478_;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos check = base.m_7918_(dx, 0, dz);
                int open = this.findCeilingDistance(level, check);
                double weight = (double)open - 4.0;
                lean = lean.m_82520_((double)dx * weight, 0.0, (double)dz * weight);
            }
        }
        if (lean.m_82556_() < 0.01) {
            return Vec3.f_82478_;
        }
        return lean.m_82541_();
    }

    private Vec3 exaggerateLean(WorldGenLevel level, BlockPos base, Vec3 lean) {
        if (lean.m_82556_() < 0.01) {
            return lean;
        }
        int radius = 4;
        ArrayList<Integer> samples = new ArrayList<Integer>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                samples.add(this.findCeilingDistance(level, base.m_7918_(dx, 0, dz)));
            }
        }
        double avg = samples.stream().mapToInt(i -> i).average().orElse(0.0);
        double stddev = Math.sqrt(samples.stream().mapToDouble(v -> ((double)v.intValue() - avg) * ((double)v.intValue() - avg)).sum() / (double)samples.size());
        double factor = Mth.m_14008_((double)(0.7 + stddev * 0.25), (double)0.7, (double)2.2);
        return lean.m_82541_().m_82490_(factor);
    }

    private boolean hasEnoughSpace(LevelAccessor level, BlockPos base, int height, Vec3 leanDir) {
        int blocked = 0;
        for (int i = 0; i <= height + 3; ++i) {
            Vec3 offset = leanDir.m_82490_((double)((float)i / (float)height) * 1.4);
            BlockPos check = base.m_7918_((int)offset.f_82479_, i, (int)offset.f_82481_);
            if (level.m_46859_(check) || ++blocked <= 12) continue;
            return false;
        }
        return true;
    }

    private void generateStem(LevelAccessor level, BlockPos base, int height, Vec3 leanDir, LargeMushroomConfiguration cfg, RandomSource random) {
        BlockState stem = cfg.stemBlock().m_213972_(random, base);
        BlockState wood = cfg.woodBlock().m_213972_(random, base);
        level.m_7731_(base.m_7495_(), stem, 2);
        BlockPos lastPos = base;
        for (int i = 0; i < height; ++i) {
            Vec3 offset = leanDir.m_82490_((double)((float)i / (float)height) * 1.2);
            BlockPos pos = base.m_7918_((int)offset.f_82479_, i, (int)offset.f_82481_);
            if (level.m_46859_(pos)) {
                level.m_7731_(pos, stem, 2);
            }
            if ((pos.m_123341_() != lastPos.m_123341_() || pos.m_123343_() != lastPos.m_123343_()) && i > 0) {
                if (level.m_8055_(lastPos).m_60713_(stem.m_60734_())) {
                    level.m_7731_(lastPos, wood, 2);
                }
                if (level.m_8055_(pos).m_60713_(stem.m_60734_())) {
                    level.m_7731_(pos, wood, 2);
                }
            }
            lastPos = pos;
        }
    }

    private void generateCap(LevelAccessor level, BlockPos top, Vec3 leanDir, LargeMushroomConfiguration cfg, RandomSource random, int stemHeight, LargeMushroomCapShape shape) {
        Vec3 capOffset = leanDir.m_82490_(1.0);
        BlockPos center = top.m_7918_((int)capOffset.f_82479_, shape.yOffset(), (int)capOffset.f_82481_);
        BlockState capBlock = cfg.capBlock().m_213972_(random, center);
        int radius = this.computeCapRadius(level, center, stemHeight, 6);
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos decoPos;
                double dist = Math.sqrt(dx * dx + dz * dz);
                if (dist > (double)radius + 0.3) continue;
                int capHeight = this.computeCapShape(shape, dist, radius);
                BlockPos pos = center.m_7918_(dx, capHeight, dz);
                if (level.m_46859_(pos)) {
                    level.m_7731_(pos, capBlock, 2);
                }
                double innerRadius = (float)radius * 0.8f;
                if (!this.canDecorate(shape) || !(dist < innerRadius) || !(random.m_188501_() < 0.35f) || cfg.decoratorBlocks().isEmpty() || !level.m_46859_(decoPos = pos.m_7495_())) continue;
                BlockState deco = cfg.decoratorBlocks().get(random.m_188503_(cfg.decoratorBlocks().size())).m_213972_(random, decoPos);
                level.m_7731_(decoPos, deco, 2);
            }
        }
    }

    private int measureHeadroom(LevelAccessor level, BlockPos basePos, int maxSearch) {
        for (int dy = 1; dy < maxSearch; ++dy) {
            BlockPos checkPos = basePos.m_6630_(dy);
            if (level.m_8055_(checkPos).m_60795_()) continue;
            return dy - 1;
        }
        return maxSearch;
    }

    private double measureLateralOpenness(LevelAccessor level, BlockPos basePos, int maxRadius) {
        int openDirs = 0;
        int totalDirs = 0;
        for (int dx = -maxRadius; dx <= maxRadius; dx += maxRadius / 2) {
            for (int dz = -maxRadius; dz <= maxRadius; dz += maxRadius / 2) {
                if (dx == 0 && dz == 0) continue;
                ++totalDirs;
                BlockPos check = basePos.m_7918_(dx, 1, dz);
                if (!level.m_8055_(check).m_60795_()) continue;
                ++openDirs;
            }
        }
        return (double)openDirs / (double)totalDirs;
    }

    private int computeCapRadius(LevelAccessor level, BlockPos basePos, int trunkHeight, int maxRadius) {
        int headroom = this.measureHeadroom(level, basePos, 12);
        double openness = this.measureLateralOpenness(level, basePos, 6);
        double heightFactor = 1.0 - Math.exp((double)(-trunkHeight) / 5.0);
        double spaceFactor = Math.min(1.0, (double)headroom / (double)trunkHeight * 0.8 + openness * 0.2);
        double variation = (double)(SimplexNoise.noise((float)((float)((double)basePos.m_123341_() * 0.2)), (float)((float)((double)basePos.m_123343_() * 0.2))) + 1.0f) * 0.1 + 0.9;
        int radius = (int)((double)maxRadius * heightFactor * spaceFactor * variation);
        return Mth.m_14045_((int)radius, (int)2, (int)maxRadius);
    }

    private int computeCapShape(LargeMushroomCapShape shape, double dist, int radius) {
        return switch (shape) {
            case LargeMushroomCapShape.FLAT -> 0;
            default -> (int)(Math.cos(dist / (double)radius * Math.PI / 2.0) * 2.0);
        };
    }

    private boolean canDecorate(LargeMushroomCapShape shape) {
        return shape.canDecorate();
    }
}

