/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.custom;

import java.util.Collections;
import java.util.List;
import net.farkas.wildaside.block.custom.GlowingHickoryLeavesBlock;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.item.custom.HickoryLeafItem;
import net.farkas.wildaside.util.GlowingHickoryLightUtil;
import net.farkas.wildaside.util.HickoryColour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FallenHickoryLeavesBlock
extends Block {
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)0.5, (double)15.0);
    public static final int MAX_COUNT = 3;
    public static final EnumProperty<HickoryColour> COLOUR = EnumProperty.m_61587_((String)"colour", HickoryColour.class);
    public static final IntegerProperty COUNT = IntegerProperty.m_61631_((String)"count", (int)1, (int)3);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final int MIN_LIGHT = 0;
    private static final int MAX_LIGHT = 3;
    public static final IntegerProperty LIGHT = IntegerProperty.m_61631_((String)"light", (int)0, (int)3);
    public static final BooleanProperty FIXED_LIGHTING = BooleanProperty.m_61465_((String)"fixed_lighting");

    public FallenHickoryLeavesBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60953_(s -> (Integer)s.m_61143_((Property)LIGHT)));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(COLOUR, (Comparable)((Object)HickoryColour.HICKORY))).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(1))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(0))).m_61124_((Property)FIXED_LIGHTING, (Comparable)Boolean.valueOf(false)));
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        HickoryColour colour = (HickoryColour)((Object)pState.m_61143_(COLOUR));
        int count = (Integer)pState.m_61143_((Property)COUNT);
        return Collections.singletonList(new ItemStack((ItemLike)ModItems.LEAF_ITEMS.get((Object)colour).get(), count));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Vec3 offset = pState.m_60824_(pLevel, pPos);
        return SHAPE.m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COLOUR, COUNT, FACING, LIGHT, FIXED_LIGHTING});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        ItemStack stack = ctx.m_43722_();
        HickoryColour color = HickoryColour.HICKORY;
        Item item = stack.m_41720_();
        if (item instanceof HickoryLeafItem) {
            HickoryLeafItem leaf = (HickoryLeafItem)item;
            color = leaf.getColour();
        }
        Direction face = ctx.m_8125_().m_122424_();
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(COLOUR, (Comparable)((Object)color))).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(1))).m_61124_((Property)FACING, (Comparable)face);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_ || pHand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack playerItem = pPlayer.m_21120_(pHand);
        if (playerItem.m_41619_()) {
            int count = (Integer)pState.m_61143_((Property)COUNT);
            if (count == 1) {
                pLevel.m_7471_(pPos, false);
            } else {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)COUNT, (Comparable)Integer.valueOf(count - 1)), 3);
            }
            pPlayer.m_6674_(pHand);
            pPlayer.m_36356_(new ItemStack((ItemLike)ModItems.LEAF_ITEMS.get(pState.m_61143_(COLOUR)).get()));
            pLevel.m_5594_(null, pPos, SoundEvents.f_144081_, SoundSource.BLOCKS, 1.0f, 0.8f);
            if (!pPlayer.m_20147_()) {
                playerItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (playerItem.m_41720_().equals(ModItems.VIBRION.get())) {
            if (((Boolean)pState.m_61143_((Property)GlowingHickoryLeavesBlock.FIXED_LIGHTING)).booleanValue()) {
                return InteractionResult.PASS;
            }
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)FIXED_LIGHTING, (Comparable)Boolean.valueOf(true)), 3);
            pLevel.m_5594_(null, pPos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!pPlayer.m_20147_()) {
                playerItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
        if (!pLevel.f_46443_) {
            pLevel.m_186460_(pPos, (Block)this, 0);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_213897_(pState, pLevel, pPos, pRandom);
        if (pLevel.m_5776_() || ((Boolean)pState.m_61143_((Property)FIXED_LIGHTING)).booleanValue() || pState.m_61143_(COLOUR) == HickoryColour.HICKORY) {
            return;
        }
        int maxLight = (Integer)pState.m_61143_((Property)COUNT);
        int time = (int)pLevel.m_8044_();
        int currentLight = (Integer)pState.m_61143_((Property)LIGHT);
        int newLight = GlowingHickoryLightUtil.getLight(time, 0, maxLight);
        if (newLight != currentLight) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(newLight)));
        }
        pLevel.m_186460_(pPos, (Block)this, 100);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)ModItems.LEAF_ITEMS.get(state.m_61143_(COLOUR)).get());
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_7495_()).m_60783_((BlockGetter)pLevel, pPos.m_7495_(), Direction.UP);
    }

    public BlockState m_7417_(BlockState st, Direction side, BlockState nb, LevelAccessor w, BlockPos p, BlockPos np) {
        if (side == Direction.DOWN && !this.m_7898_(st, (LevelReader)w, p)) {
            w.m_46961_(p, true);
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(st, side, nb, w, p, np);
    }
}

