/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.block.entity;

import java.util.List;
import net.farkas.wildaside.block.custom.vibrion.SporeBlaster;
import net.farkas.wildaside.block.entity.BlasterBlockEntity;
import net.farkas.wildaside.block.entity.ModBlockEntities;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.BlasterUtils;
import net.farkas.wildaside.util.ContaminationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class SporeBlasterBlockEntity
extends BlasterBlockEntity {
    private int power = 0;

    public SporeBlasterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SPORE_BLASTER.get(), pos, state);
    }

    public void tickServer() {
        Level level = this.m_58904_();
        int power = level.m_277086_(this.f_58858_);
        if (power > 0) {
            this.infectAlongLine((ServerLevel)level, this.f_58858_, (Direction)this.m_58900_().m_61143_((Property)SporeBlaster.f_52588_), power, level.f_46441_);
        }
        level.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), 2);
    }

    private void infectAlongLine(ServerLevel world, BlockPos origin, Direction dir, int range, RandomSource rand) {
        SimpleParticleType particle = (SimpleParticleType)ModParticles.VIBRION_PARTICLE.get();
        for (int i = 1; i <= range; ++i) {
            if (this.shouldBreakNext) {
                this.shouldBreakNext = false;
                break;
            }
            BlockState originBlock = world.m_8055_(origin);
            BlockPos step = origin.m_5484_(dir, i);
            BlockState nextBlock = world.m_8055_(step);
            if (world.m_8055_(step).m_60838_((BlockGetter)world, step) || !BlasterUtils.canTraverse(dir, nextBlock, originBlock, this)) break;
            double x = (double)step.m_123341_() + rand.m_188500_();
            double y = (double)step.m_123342_() + rand.m_188500_();
            double z = (double)step.m_123343_() + rand.m_188500_();
            world.m_8767_((ParticleOptions)particle, x, y, z, 1, 0.02 * (double)dir.m_122429_(), 0.02 * (double)dir.m_122430_(), 0.02 * (double)dir.m_122431_(), 0.0);
            List hits = world.m_6443_(LivingEntity.class, new AABB(step), e -> !e.m_5833_());
            for (LivingEntity entity : hits) {
                ContaminationHandler.addDose((Entity)entity, 50);
                world.m_8767_((ParticleOptions)particle, entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), 5, 0.2, 0.2, 0.2, 0.01);
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.power = tag.m_128451_("power");
        this.shouldBreakNext = tag.m_128471_("shouldBreakNext");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("power", this.power);
        tag.m_128379_("shouldBreakNext", this.shouldBreakNext);
    }
}

