/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.custom.vibrion;

import java.util.List;
import net.farkas.wildaside.entity.ai.contaminated.ApproachWhenLookedAtGoal;
import net.farkas.wildaside.particle.ModParticles;
import net.farkas.wildaside.util.ContaminationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ContaminatedCreeperEntity
extends Creeper {
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(ContaminatedCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int STATE_IDLE = 0;
    public static final int STATE_FOLLOWING = 1;
    public static final int STATE_CHASE = 2;
    public static final int STATE_BURROWED = 3;

    public ContaminatedCreeperEntity(EntityType<? extends Creeper> type, Level level) {
        super(type, level);
        this.m_21530_();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_32318_() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 48.0);
    }

    public void explode() {
        if (!this.m_9236_().f_46443_) {
            int f = this.m_7090_() ? 2 : 1;
            int radius = 3 * f;
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)radius, Level.ExplosionInteraction.MOB);
            this.applySporeCloud(radius + 1);
            this.m_146870_();
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 64.0f));
        this.f_21345_.m_25352_(3, (Goal)new ApproachWhenLookedAtGoal(this, 1.0, 48.0, 24.0));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.getState() == 3) {
            for (int i = 0; i < 3; ++i) {
                double dx = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double dy = this.m_20186_();
                double dz = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 0.5;
                this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(), 1.0f), dx, dy, dz, 0.0, 0.05, 0.0);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("ContaminatedCreeperState", this.getState());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setState(tag.m_128451_("ContaminatedCreeperState"));
    }

    private void applySporeCloud(int radius) {
        Level level = this.m_9236_();
        RandomSource rand = level.f_46441_;
        BlockPos center = this.m_20183_();
        SimpleParticleType particle = (SimpleParticleType)ModParticles.VIBRION_PARTICLE.get();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (dx * dx + dy * dy + dz * dz > radius * radius) continue;
                    for (int i = 0; i < 3; ++i) {
                        double x = (double)center.m_123341_() + 0.5 + (double)dx + (rand.m_188500_() - 0.5);
                        double y = (double)center.m_123342_() + 0.5 + (double)dy + (rand.m_188500_() - 0.5);
                        double z = (double)center.m_123343_() + 0.5 + (double)dz + (rand.m_188500_() - 0.5);
                        level.m_7106_((ParticleOptions)particle, x, y, z, 1.0, 0.0, 0.0);
                    }
                }
            }
        }
        AABB box = new AABB(center).m_82400_((double)radius);
        List list = level.m_6443_(LivingEntity.class, box, e -> !e.m_5833_());
        for (LivingEntity entity : list) {
            ContaminationHandler.addDose((Entity)entity, rand.m_216339_(1500, 2500) * (this.m_7090_() ? 2 : 1));
            level.m_7106_((ParticleOptions)particle, entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), 5.0, 0.2, 0.2);
        }
    }

    public boolean hasAdjacentBlock(Block block) {
        for (Direction direction : Direction.values()) {
            if (!this.m_9236_().m_8055_(this.m_20183_().m_5484_(direction, 1)).m_60713_(block)) continue;
            return true;
        }
        return false;
    }
}

