/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.custom.vibrion;

import java.util.ArrayList;
import java.util.List;
import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.entity.ModEntities;
import net.farkas.wildaside.item.ModItems;
import net.farkas.wildaside.util.AdvancementHandler;
import net.farkas.wildaside.util.WeightedFlowerChoice;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FertiliserBombEntity
extends ThrowableItemProjectile {
    private final float charge;
    private final LivingEntity thrower;
    final List<WeightedFlowerChoice.WeightedFlower> flowerList = new ArrayList<WeightedFlowerChoice.WeightedFlower>(List.of(new WeightedFlowerChoice.WeightedFlower(5, Blocks.f_50111_), new WeightedFlowerChoice.WeightedFlower(5, Blocks.f_50112_), new WeightedFlowerChoice.WeightedFlower(3, Blocks.f_50113_), new WeightedFlowerChoice.WeightedFlower(2, Blocks.f_50114_), new WeightedFlowerChoice.WeightedFlower(2, Blocks.f_50117_), new WeightedFlowerChoice.WeightedFlower(2, Blocks.f_50119_), new WeightedFlowerChoice.WeightedFlower(2, Blocks.f_50116_), new WeightedFlowerChoice.WeightedFlower(2, Blocks.f_50118_), new WeightedFlowerChoice.WeightedFlower(2, Blocks.f_50120_), new WeightedFlowerChoice.WeightedFlower(2, Blocks.f_50121_), new WeightedFlowerChoice.WeightedFlower(1, Blocks.f_50115_)));
    final WeightedFlowerChoice flowerChoice = new WeightedFlowerChoice(this.flowerList);

    public FertiliserBombEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.charge = this.m_9236_().f_46441_.m_188501_();
        this.thrower = null;
    }

    public FertiliserBombEntity(Level pLevel, LivingEntity thrower, float charge) {
        super((EntityType)ModEntities.FERTILISER_BOMB.get(), thrower, pLevel);
        this.charge = charge + 0.1f;
        this.thrower = thrower;
    }

    public FertiliserBombEntity(Level pLevel, double pX, double pY, double pZ) {
        super((EntityType)ModEntities.FERTILISER_BOMB.get(), pX, pY, pZ, pLevel);
        this.charge = this.m_9236_().f_46441_.m_188501_();
        this.thrower = null;
    }

    public FertiliserBombEntity(Level pLevel) {
        super((EntityType)ModEntities.FERTILISER_BOMB.get(), pLevel);
        this.charge = this.m_9236_().f_46441_.m_188501_();
        this.thrower = null;
    }

    protected Item m_7881_() {
        return (Item)ModItems.FERTILISER_BOMB.get();
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_ && result.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 loc = result.m_82450_();
            BlockPos impactPos = new BlockPos((int)loc.f_82479_, (int)loc.f_82480_, (int)loc.f_82481_);
            this.applyAreaEffect((ServerLevel)this.m_9236_(), impactPos, this.charge);
            this.m_146870_();
        }
    }

    private void applyAreaEffect(ServerLevel level, BlockPos center, float charge) {
        int radius = Mth.m_14167_((float)(2.0f + charge * 2.0f));
        int verticalRange = 1;
        int radiusSq = radius * radius;
        RandomSource random = level.m_213780_();
        Holder biomeHolder = level.m_204166_(center);
        String biomePath = biomeHolder.m_203543_().map(key -> key.m_135782_().m_135815_()).orElse("");
        if (biomePath.contains("hickory")) {
            AdvancementHandler.givePlayerAdvancement((Entity)((ServerPlayer)this.thrower), "fertile_forest");
            this.flowerList.add(new WeightedFlowerChoice.WeightedFlower(4, (Block)ModBlocks.SPOTTED_WINTERGREEN.get()));
            this.flowerList.add(new WeightedFlowerChoice.WeightedFlower(4, (Block)ModBlocks.PINKSTER_FLOWER.get()));
        }
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                if (dx * dx + dz * dz > radiusSq) continue;
                for (int dy = -verticalRange; dy <= verticalRange; ++dy) {
                    BlockPos pos = center.m_7918_(dx, dy, dz);
                    this.applyEffectAt(level, pos, random, charge);
                }
            }
        }
    }

    private void applyEffectAt(ServerLevel level, BlockPos pos, RandomSource random, float charge) {
        BonemealableBlock bonemealBlockBelow;
        BlockPos below;
        BlockState belowState;
        Block block;
        BonemealableBlock bonemealBlock;
        BlockState state = level.m_8055_(pos);
        Block block2 = state.m_60734_();
        if (block2 instanceof FarmBlock) {
            FarmBlock farm = (FarmBlock)block2;
            if (this.chance(random, charge * 0.5f)) {
                int moisture = (Integer)state.m_61143_((Property)FarmBlock.f_53243_);
                if (moisture < 7) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(7)), 3);
                    this.spawnSplash((Level)level, pos);
                }
                return;
            }
        }
        if (state.m_60795_() && level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) && this.chance(random, charge * 0.3f)) {
            BlockState flower = this.flowerChoice.selectFlower(random);
            level.m_7731_(pos, flower, 3);
            this.spawnHappy((Level)level, pos);
            return;
        }
        Block moisture = state.m_60734_();
        if (moisture instanceof BonemealableBlock && (bonemealBlock = (BonemealableBlock)moisture).m_7370_((LevelReader)level, pos, state, false) && this.chance(random, charge * 0.3f)) {
            bonemealBlock.m_214148_(level, random, pos, state);
            level.m_46796_(2005, pos, 0);
            this.spawnSplash((Level)level, pos);
            return;
        }
        if (state.m_60795_() && (block = (belowState = level.m_8055_(below = pos.m_7495_())).m_60734_()) instanceof BonemealableBlock && (bonemealBlockBelow = (BonemealableBlock)block).m_7370_((LevelReader)level, below, belowState, false) && this.chance(random, charge * 0.2f)) {
            bonemealBlockBelow.m_214148_(level, random, below, belowState);
            level.m_46796_(2005, below, 0);
            this.spawnSplash((Level)level, pos);
        }
    }

    private boolean chance(RandomSource random, float factor) {
        return random.m_188501_() < factor;
    }

    private void spawnSplash(Level level, BlockPos pos) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 5.0, 0.2, 0.2);
    }

    private void spawnHappy(Level level, BlockPos pos) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.7, (double)pos.m_123343_() + 0.5, 10.0, 0.2, 0.2);
    }
}

