/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.entity.custom.hickory;

import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.block.custom.RootBushBlock;
import net.farkas.wildaside.entity.ai.hickory.HickoryTreantBeamAttackGoal;
import net.farkas.wildaside.entity.ai.hickory.HickoryTreantMeleeAttackGoal;
import net.farkas.wildaside.entity.ai.hickory.HickoryTreantRootAttackGoal;
import net.farkas.wildaside.entity.custom.hickory.HickoryLeafProjectile;
import net.farkas.wildaside.util.HickoryColour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HickoryTreantEntity
extends Monster {
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(HickoryTreantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int rootCooldown;
    public int beamCooldown;
    public int previousAttackX = 0;
    public int previousAttackY = 0;
    public int previousAttackZ = 0;
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237115_((String)"entity.wildaside.hickory_treant"), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.NOTCHED_12);

    public HickoryTreantEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.rootCooldown = this.getRootInterval(1);
        this.beamCooldown = this.getBeamInterval(1);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 36.0).m_22268_(Attributes.f_22278_, 0.8);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Blaze.class, false));
        this.f_21345_.m_25352_(3, (Goal)new HickoryTreantRootAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new HickoryTreantBeamAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new HickoryTreantMeleeAttackGoal((PathfinderMob)this, 0.5, true));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 36.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Blaze.class, 36.0f));
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
        this.resetRoots();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PHASE, (Object)1);
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.animationHandler();
        }
    }

    private void animationHandler() {
    }

    public void m_8107_() {
        super.m_8107_();
        --this.rootCooldown;
        --this.beamCooldown;
        this.setPhase(this.updatePhase());
        if (this.m_5448_() != null) {
            this.m_21573_().m_5624_((Entity)this.m_5448_(), 1.0);
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
        }
        this.bossEvent.m_142711_(this.healthPresentage());
        switch (this.getPhase()) {
            case 1: {
                this.bossEvent.m_6451_(BossEvent.BossBarColor.GREEN);
                break;
            }
            case 2: {
                this.bossEvent.m_6451_(BossEvent.BossBarColor.YELLOW);
                break;
            }
            case 3: {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, -1, 0, false, false));
                this.bossEvent.m_6451_(BossEvent.BossBarColor.RED);
                break;
            }
            case 4: {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, -1, 1, false, false));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, -1, 1, false, false));
                this.bossEvent.m_6451_(BossEvent.BossBarColor.WHITE);
            }
        }
    }

    public float healthPresentage() {
        return this.m_21223_() / this.m_21233_();
    }

    private int updatePhase() {
        double percent = this.healthPresentage();
        if (percent <= 0.25) {
            return 4;
        }
        if (percent <= 0.5) {
            return 3;
        }
        if (percent <= 0.75) {
            return 2;
        }
        return 1;
    }

    public int getRootInterval(int phase) {
        return switch (phase) {
            case 2 -> 140;
            case 3 -> 120;
            case 4 -> 100;
            default -> 160;
        };
    }

    public int getBeamInterval(int phase) {
        return switch (phase) {
            case 3 -> 80;
            case 4 -> 60;
            default -> 100;
        };
    }

    public int getRootPatchRadius(int phase) {
        return phase >= 3 ? 2 : 1;
    }

    public void doRootingAttack(int phase) {
        this.resetRoots();
        Level level = this.m_9236_();
        BlockPos rootPos = this.m_5448_().m_20183_().m_7495_();
        this.previousAttackX = rootPos.m_123341_();
        this.previousAttackY = rootPos.m_123342_();
        this.previousAttackZ = rootPos.m_123343_();
        int radius = this.getRootPatchRadius(phase);
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos;
                    BlockPos placePos;
                    if (Math.abs(dx) == radius && Math.abs(dz) == radius || !level.m_46859_(placePos = (pos = rootPos.m_7918_(dx, dy, dz)).m_7494_()) && !level.m_8055_(placePos).m_247087_() || !level.m_8055_(pos).m_60783_((BlockGetter)level, pos, Direction.UP)) continue;
                    level.m_7731_(placePos, (BlockState)((Block)ModBlocks.HICKORY_ROOT_BUSH.get()).m_49966_().m_61124_((Property)RootBushBlock.f_57244_, (Comparable)Integer.valueOf(phase - 1)), 3);
                }
            }
        }
    }

    public void resetRoots() {
        Level level = this.m_9236_();
        BlockPos rootPos = new BlockPos(this.previousAttackX, this.previousAttackY, this.previousAttackZ);
        int radius = 2;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos = rootPos.m_7918_(dx, dy, dz);
                    BlockPos placePos = pos.m_7494_();
                    if (!(level.m_8055_(placePos).m_60734_() instanceof RootBushBlock)) continue;
                    level.m_7471_(placePos, false);
                }
            }
        }
    }

    public void doBeamAttack(int phase) {
        Level level = this.m_9236_();
        LivingEntity target = this.m_5448_();
        RandomSource random = this.m_217043_();
        HickoryColour[] values = HickoryColour.values();
        HickoryColour colour = values[random.m_188503_(values.length)];
        int count = phase * 8;
        float speed = phase >= 3 ? 2.0f : 1.5f;
        Vec3 start = this.m_20182_().m_82520_(0.0, (double)this.m_20192_() * 0.5, 0.0);
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() * 0.5, 0.0);
        Vec3 delta = targetPos.m_82546_(start);
        for (int i = 0; i < count; ++i) {
            HickoryLeafProjectile proj = new HickoryLeafProjectile(level, (LivingEntity)this, colour);
            proj.m_146884_(start);
            proj.m_6686_(delta.f_82479_, delta.f_82480_, delta.f_82481_, speed, 40 - phase * 2);
            level.m_7967_((Entity)proj);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("phase", this.getPhase());
        tag.m_128405_("rootCD", this.rootCooldown);
        tag.m_128405_("beamCD", this.beamCooldown);
        tag.m_128405_("paX", this.previousAttackX);
        tag.m_128405_("paY", this.previousAttackY);
        tag.m_128405_("paZ", this.previousAttackZ);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setPhase(tag.m_128451_("phase"));
        this.rootCooldown = tag.m_128451_("rootCD");
        this.beamCooldown = tag.m_128451_("beamCD");
        this.previousAttackX = tag.m_128451_("paX");
        this.previousAttackY = tag.m_128451_("paY");
        this.previousAttackZ = tag.m_128451_("paZ");
    }

    public void m_6457_(ServerPlayer pServerPlayer) {
        super.m_6457_(pServerPlayer);
        this.bossEvent.m_6543_(pServerPlayer);
    }

    public void m_6452_(ServerPlayer pServerPlayer) {
        super.m_6452_(pServerPlayer);
        this.bossEvent.m_6539_(pServerPlayer);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_276093_(DamageTypes.f_268468_) || pSource.m_276093_(DamageTypes.f_268631_)) {
            pAmount *= 2.0f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12638_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12634_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12630_;
    }
}

