/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.event;

import com.mojang.brigadier.CommandDispatcher;
import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.capability.contamination.ContaminationAttacher;
import net.farkas.wildaside.capability.contamination.ContaminationCapability;
import net.farkas.wildaside.command.ModCommands;
import net.farkas.wildaside.effect.ModMobEffects;
import net.farkas.wildaside.network.WindSavedData;
import net.farkas.wildaside.util.AdvancementHandler;
import net.farkas.wildaside.util.ContaminationHandler;
import net.farkas.wildaside.util.WindManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wildaside", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    private static final ResourceLocation GLOWING_HICKORY_FOREST = new ResourceLocation("wildaside", "glowing_hickory_forest");

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        ContaminationAttacher.ContaminationProvider provider = new ContaminationAttacher.ContaminationProvider();
        event.addCapability(ContaminationAttacher.ContaminationProvider.IDENTIFIER, (ICapabilityProvider)provider);
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        ModCommands.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AdvancementHandler.givePlayerAdvancement((Entity)player2, "wild_wilder_wildest");
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        ModEvents.loadWind(event);
    }

    public static void loadWind(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        if (!serverLevel.m_46472_().equals((Object)ServerLevel.f_46428_)) {
            return;
        }
        WindSavedData data = WindSavedData.get(serverLevel);
        Vec3 dir = data.getWindDirection();
        float strength = data.getWindStrength();
        WindManager.setWind(dir, strength);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        ModEvents.manageWeather(event);
    }

    public static void manageWeather(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = event.getServer();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        if (overworld == null) {
            return;
        }
        WindSavedData weatherData = WindSavedData.get(overworld);
        boolean raining = overworld.m_46471_();
        boolean thundering = overworld.m_46470_();
        if (raining != weatherData.wasRaining() || thundering != weatherData.wasThundering()) {
            WindManager.calculateAndSetWind(overworld, false);
        }
        int time = 1200;
        if (server.m_129921_() % time == 0) {
            WindManager.calculateAndSetWind(overworld, true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_9236_().f_46443_) {
            return;
        }
        ModEvents.glowUpAdvancement(event);
        ModEvents.clipContextCheckingTickEvent(event);
    }

    private static void glowUpAdvancement(TickEvent.PlayerTickEvent event) {
        Holder biomeHolder;
        ResourceKey biomeKey;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        ServerLevel world = player.m_284548_();
        long time = world.m_46468_();
        if (time >= 14000L && time <= 22000L && (biomeKey = (ResourceKey)(biomeHolder = world.m_204166_(player.m_20183_())).m_203543_().orElse(null)) != null && biomeKey.m_135782_().equals((Object)GLOWING_HICKORY_FOREST)) {
            AdvancementHandler.givePlayerAdvancement((Entity)player, "glow_up");
        }
    }

    private static void clipContextCheckingTickEvent(TickEvent.PlayerTickEvent event) {
        ClipContext clipContext;
        BlockPos blockPos;
        ServerPlayer player = (ServerPlayer)event.player;
        ServerLevel level = player.m_284548_();
        Block block = level.m_8055_(blockPos = level.m_45547_(clipContext = new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_82425_()).m_60734_();
        if (block.equals(ModBlocks.OVERGROWN_ENTORIUM_ORE.get())) {
            AdvancementHandler.givePlayerAdvancement((Entity)player, "its_shearing_time");
        } else if (block.equals(ModBlocks.SPORE_BLASTER.get()) && level.m_277086_(blockPos) > 0) {
            AdvancementHandler.givePlayerAdvancement((Entity)player, "bacteria_beacon");
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getPlayer().m_9236_().f_46443_) {
            return;
        }
        ModEvents.blasterBustedAdvancement(event);
    }

    public static void blasterBustedAdvancement(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_8055_(event.getPos()).m_60734_() == ModBlocks.NATURAL_SPORE_BLASTER.get()) {
            AdvancementHandler.givePlayerAdvancement((Entity)((ServerPlayer)event.getPlayer()), "blaster_busted");
        }
    }

    @SubscribeEvent
    public static void onMobEffectExpired(MobEffectEvent.Expired event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        ModEvents.onContaminationEffectExpired(event);
    }

    public static void onContaminationEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance mobEffectInstance = event.getEffectInstance();
        if (mobEffectInstance != null && mobEffectInstance.m_19544_() == ModMobEffects.CONTAMINATION.get()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.IMMUNITY.get(), (mobEffectInstance.m_19564_() + 1) * 5 * 20, mobEffectInstance.m_19564_()));
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        if (event.getEntity().m_9236_().f_46443_ || !event.isVanillaCritical()) {
            return;
        }
        ModEvents.spreadContaminationOnCriticalHit(event);
    }

    public static void spreadContaminationOnCriticalHit(CriticalHitEvent event) {
        ModMobEffects.CONTAMINATION.getHolder().ifPresent(contamEffect -> {
            MobEffect contamination = (MobEffect)contamEffect.get();
            Player attacker = event.getEntity();
            if (attacker == null) {
                return;
            }
            if (attacker.m_21023_(contamination)) {
                Entity patt8663$temp;
                RandomSource random = attacker.m_217043_();
                if ((float)attacker.m_21124_(contamination).m_19564_() / 5.0f > random.m_188501_() && (patt8663$temp = event.getTarget()) instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)patt8663$temp;
                    attacker.getCapability(ContaminationCapability.INSTANCE).ifPresent(data -> ContaminationHandler.addDose((Entity)target, data.getDose() / 5));
                }
            }
        });
    }

    @SubscribeEvent
    public static void livingEntityTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        ModEvents.passiveContaminationDoseReduction(event);
    }

    public static void passiveContaminationDoseReduction(LivingEvent.LivingTickEvent event) {
        event.getEntity().getCapability(ContaminationCapability.INSTANCE).ifPresent(data -> data.addDose(-10));
    }
}

