/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.farkas.wildaside.block.ModBlocks;
import net.farkas.wildaside.util.HickoryColour;
import net.farkas.wildaside.util.LargeMushroomCapShape;
import net.farkas.wildaside.worldgen.feature.ModFeatures;
import net.farkas.wildaside.worldgen.feature.configuration.LargeMushroomConfiguration;
import net.farkas.wildaside.worldgen.feature.custom.FallenHickoryTreeFeature;
import net.farkas.wildaside.worldgen.feature.custom.HangingStringFeature;
import net.farkas.wildaside.worldgen.feature.custom.HickoryBushFeature;
import net.farkas.wildaside.worldgen.feature.custom.LargeMushroomFeature;
import net.farkas.wildaside.worldgen.feature.custom.NaturalSporeBlasterFeature;
import net.farkas.wildaside.worldgen.feature.decorator.FallenLeavesDecorator;
import net.farkas.wildaside.worldgen.feature.tree.hickory.HickoryTreeFoliagePlacer;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_SUBSTILIUM_MUSHROOM = ModConfiguredFeatures.registerKey("large_substilium_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VIBRION_GROWTH = ModConfiguredFeatures.registerKey("vibrion_growth");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VIBRION_SPOREHOLDER = ModConfiguredFeatures.registerKey("vibrion_sporeholder");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_SPROUTS = ModConfiguredFeatures.registerKey("substilium_sprouts");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HANGING_VIBRION_VINES = ModConfiguredFeatures.registerKey("hanging_vibrion_vines");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HANGING_VIBRION_GEL = ModConfiguredFeatures.registerKey("hanging_vibrion_gel");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HANGING_LIT_VIBRION_GEL = ModConfiguredFeatures.registerKey("hanging_lit_vibrion_gel");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERGROWN_ENTORIUM_ORE = ModConfiguredFeatures.registerKey("overgrown_entorium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_COAL_ORE = ModConfiguredFeatures.registerKey("substilium_coal_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_COPPER_ORE_SMALL = ModConfiguredFeatures.registerKey("substilium_copper_ore_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_COPPER_ORE_LARGE = ModConfiguredFeatures.registerKey("substilium_copper_ore_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_LAPIS_ORE = ModConfiguredFeatures.registerKey("substilium_lapis_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_LAPIS_ORE_BURIED = ModConfiguredFeatures.registerKey("substilium_lapis_ore_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_IRON_ORE = ModConfiguredFeatures.registerKey("substilium_iron_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_IRON_ORE_SMALL = ModConfiguredFeatures.registerKey("substilium_iron_ore_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_GOLD_ORE = ModConfiguredFeatures.registerKey("substilium_gold_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_GOLD_ORE_BURIED = ModConfiguredFeatures.registerKey("substilium_gold_ore_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_REDSTONE_ORE = ModConfiguredFeatures.registerKey("substilium_redstone_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_DIAMOND_ORE_SMALL = ModConfiguredFeatures.registerKey("substilium_diamond_ore_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_DIAMOND_ORE_LARGE = ModConfiguredFeatures.registerKey("substilium_diamond_ore_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_DIAMOND_ORE_BURIED = ModConfiguredFeatures.registerKey("substilium_diamond_ore_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUBSTILIUM_EMERALD_ORE = ModConfiguredFeatures.registerKey("substilium_emerald_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COMPRESSED_SUBSTILIUM_SOIL = ModConfiguredFeatures.registerKey("compressed_substilium_soil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_SPORE_BLASTER = ModConfiguredFeatures.registerKey("natural_spore_blaster");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPOTTED_EVERGREEN = ModConfiguredFeatures.registerKey("spotted_evergreen");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINKSTER_FLOWER = ModConfiguredFeatures.registerKey("pinkster_flower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EXTRA_TALL_GRASS = ModConfiguredFeatures.registerKey("extra_tall_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EXTRA_FERNS = ModConfiguredFeatures.registerKey("extra_ferns");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EXTRA_TALL_FERNS = ModConfiguredFeatures.registerKey("extra_tall_ferns");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HICKORY_TREE = ModConfiguredFeatures.registerKey("hickory_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_GLOWING_HICKORY_TREE = ModConfiguredFeatures.registerKey("red_glowing_hickory_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BROWN_GLOWING_HICKORY_TREE = ModConfiguredFeatures.registerKey("brown_glowing_hickory_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> YELLOW_GLOWING_HICKORY_TREE = ModConfiguredFeatures.registerKey("yellow_glowing_hickory_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GREEN_GLOWING_HICKORY_TREE = ModConfiguredFeatures.registerKey("green_glowing_hickory_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HICKORY_SAPLING = ModConfiguredFeatures.registerKey("hickory_sapling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_GLOWING_HICKORY_SAPLING = ModConfiguredFeatures.registerKey("red_glowing_hickory_sapling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BROWN_GLOWING_HICKORY_SAPLING = ModConfiguredFeatures.registerKey("brown_glowing_hickory_sapling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> YELLOW_GLOWING_HICKORY_SAPLING = ModConfiguredFeatures.registerKey("yellow_glowing_hickory_sapling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GREEN_GLOWING_HICKORY_SAPLING = ModConfiguredFeatures.registerKey("green_glowing_hickory_sapling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HICKORY_BUSH = ModConfiguredFeatures.registerKey("hickory_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_GLOWING_HICKORY_BUSH = ModConfiguredFeatures.registerKey("red_glowing_hickory_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BROWN_GLOWING_HICKORY_BUSH = ModConfiguredFeatures.registerKey("brown_glowing_hickory_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> YELLOW_GLOWING_HICKORY_BUSH = ModConfiguredFeatures.registerKey("yellow_glowing_hickory_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GREEN_GLOWING_HICKORY_BUSH = ModConfiguredFeatures.registerKey("green_glowing_hickory_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_HICKORY_TREE = ModConfiguredFeatures.registerKey("fallen_hickory_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PODZOL_VEIN = ModConfiguredFeatures.registerKey("podzol_vein");
    public static final EnumMap<HickoryColour, ResourceKey<ConfiguredFeature<?, ?>>> HICKORY_TREES = new EnumMap(HickoryColour.class);
    public static final EnumMap<HickoryColour, ResourceKey<ConfiguredFeature<?, ?>>> HICKORY_SAPLINGS;
    public static final EnumMap<HickoryColour, ResourceKey<ConfiguredFeature<?, ?>>> HICKORY_BUSHES;
    static final BeehiveDecorator glowingBeehive;
    static final ImmutableList hickoryDecorator;
    static final ImmutableList redGlowingHickoryDecorator;
    static final ImmutableList brownGlowingHickoryDecorator;
    static final ImmutableList yellowGlowingHickoryDecorator;
    static final ImmutableList greenGlowingHickoryDecorator;
    public static final EnumMap<HickoryColour, ImmutableList> DECORATORS;

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        BlockMatchTest substilium_soil_replace = new BlockMatchTest((Block)ModBlocks.SUBSTILIUM_SOIL.get());
        BlockMatchTest grass_replace = new BlockMatchTest(Blocks.f_50440_);
        List<OreConfiguration.TargetBlockState> overgrown_entorium_ore = List.of(OreConfiguration.m_161021_((RuleTest)substilium_soil_replace, (BlockState)((Block)ModBlocks.OVERGROWN_ENTORIUM_ORE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> compressed_substilium_soil = List.of(OreConfiguration.m_161021_((RuleTest)substilium_soil_replace, (BlockState)((Block)ModBlocks.COMPRESSED_SUBSTILIUM_SOIL.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> substilium_coal_ore = List.of(OreConfiguration.m_161021_((RuleTest)substilium_soil_replace, (BlockState)((Block)ModBlocks.SUBSTILIUM_COAL_ORE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> substilium_copper_ore = List.of(OreConfiguration.m_161021_((RuleTest)substilium_soil_replace, (BlockState)((Block)ModBlocks.SUBSTILIUM_COPPER_ORE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> substilium_lapis_ore = List.of(OreConfiguration.m_161021_((RuleTest)substilium_soil_replace, (BlockState)((Block)ModBlocks.SUBSTILIUM_LAPIS_ORE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> substilium_iron_ore = List.of(OreConfiguration.m_161021_((RuleTest)substilium_soil_replace, (BlockState)((Block)ModBlocks.SUBSTILIUM_IRON_ORE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> substilium_gold_ore = List.of(OreConfiguration.m_161021_((RuleTest)substilium_soil_replace, (BlockState)((Block)ModBlocks.SUBSTILIUM_GOLD_ORE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> substilium_redstone_ore = List.of(OreConfiguration.m_161021_((RuleTest)substilium_soil_replace, (BlockState)((Block)ModBlocks.SUBSTILIUM_REDSTONE_ORE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> substilium_diamond_ore = List.of(OreConfiguration.m_161021_((RuleTest)substilium_soil_replace, (BlockState)((Block)ModBlocks.SUBSTILIUM_DIAMOND_ORE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> substilium_emerald_ore = List.of(OreConfiguration.m_161021_((RuleTest)substilium_soil_replace, (BlockState)((Block)ModBlocks.SUBSTILIUM_EMERALD_ORE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> podzol_vein = List.of(OreConfiguration.m_161021_((RuleTest)grass_replace, (BlockState)Blocks.f_50599_.m_49966_()));
        ModConfiguredFeatures.register(context, OVERGROWN_ENTORIUM_ORE, Feature.f_65731_, new OreConfiguration(overgrown_entorium_ore, 16));
        ModConfiguredFeatures.register(context, SUBSTILIUM_COAL_ORE, Feature.f_65731_, new OreConfiguration(substilium_coal_ore, 17, 0.5f));
        ModConfiguredFeatures.register(context, SUBSTILIUM_COPPER_ORE_SMALL, Feature.f_65731_, new OreConfiguration(substilium_copper_ore, 10));
        ModConfiguredFeatures.register(context, SUBSTILIUM_COPPER_ORE_LARGE, Feature.f_65731_, new OreConfiguration(substilium_copper_ore, 20));
        ModConfiguredFeatures.register(context, SUBSTILIUM_LAPIS_ORE, Feature.f_65731_, new OreConfiguration(substilium_lapis_ore, 7));
        ModConfiguredFeatures.register(context, SUBSTILIUM_LAPIS_ORE_BURIED, Feature.f_65731_, new OreConfiguration(substilium_lapis_ore, 7, 1.0f));
        ModConfiguredFeatures.register(context, SUBSTILIUM_IRON_ORE, Feature.f_65731_, new OreConfiguration(substilium_iron_ore, 9));
        ModConfiguredFeatures.register(context, SUBSTILIUM_IRON_ORE_SMALL, Feature.f_65731_, new OreConfiguration(substilium_iron_ore, 4));
        ModConfiguredFeatures.register(context, SUBSTILIUM_GOLD_ORE, Feature.f_65731_, new OreConfiguration(substilium_gold_ore, 16));
        ModConfiguredFeatures.register(context, SUBSTILIUM_GOLD_ORE_BURIED, Feature.f_65731_, new OreConfiguration(substilium_gold_ore, 9));
        ModConfiguredFeatures.register(context, SUBSTILIUM_REDSTONE_ORE, Feature.f_65731_, new OreConfiguration(substilium_redstone_ore, 9, 0.5f));
        ModConfiguredFeatures.register(context, SUBSTILIUM_DIAMOND_ORE_SMALL, Feature.f_65731_, new OreConfiguration(substilium_diamond_ore, 4, 0.5f));
        ModConfiguredFeatures.register(context, SUBSTILIUM_DIAMOND_ORE_LARGE, Feature.f_65731_, new OreConfiguration(substilium_diamond_ore, 12, 0.7f));
        ModConfiguredFeatures.register(context, SUBSTILIUM_DIAMOND_ORE_BURIED, Feature.f_65731_, new OreConfiguration(substilium_diamond_ore, 8, 1.0f));
        ModConfiguredFeatures.register(context, SUBSTILIUM_EMERALD_ORE, Feature.f_65731_, new OreConfiguration(substilium_emerald_ore, 3));
        ModConfiguredFeatures.register(context, COMPRESSED_SUBSTILIUM_SOIL, Feature.f_65731_, new OreConfiguration(compressed_substilium_soil, 36));
        ModConfiguredFeatures.register(context, NATURAL_SPORE_BLASTER, (NaturalSporeBlasterFeature)((Object)ModFeatures.NATURAL_SPORE_BLASTER_FEATURE.get()), new ReplaceBlockConfiguration(((Block)ModBlocks.SUBSTILIUM_SOIL.get()).m_49966_(), ((Block)ModBlocks.NATURAL_SPORE_BLASTER.get()).m_49966_()));
        ModConfiguredFeatures.register(context, VIBRION_GROWTH, Feature.f_65761_, new RandomPatchConfiguration(32, 8, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.VIBRION_GROWTH.get()))))));
        ModConfiguredFeatures.register(context, VIBRION_SPOREHOLDER, Feature.f_65761_, new RandomPatchConfiguration(32, 8, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.VIBRION_SPOREHOLDER.get()))))));
        ModConfiguredFeatures.register(context, SUBSTILIUM_SPROUTS, Feature.f_65761_, new RandomPatchConfiguration(32, 8, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.SUBSTILIUM_SPROUTS.get()))))));
        SimpleStateProvider vines_plant = BlockStateProvider.m_191382_((Block)((Block)ModBlocks.HANGING_VIBRION_VINES_PLANT.get()));
        SimpleStateProvider vines = BlockStateProvider.m_191382_((Block)((Block)ModBlocks.HANGING_VIBRION_VINES.get()));
        ModConfiguredFeatures.register(context, HANGING_VIBRION_VINES, Feature.f_190875_, new BlockColumnConfiguration(List.of(BlockColumnConfiguration.m_191218_((IntProvider)new WeightedListInt(SimpleWeightedRandomList.m_146263_().m_146271_((Object)UniformInt.m_146622_((int)0, (int)25), 3).m_146271_((Object)UniformInt.m_146622_((int)0, (int)2), 3).m_146271_((Object)UniformInt.m_146622_((int)0, (int)6), 7).m_146270_()), (BlockStateProvider)vines_plant), BlockColumnConfiguration.m_191218_((IntProvider)ConstantInt.m_146483_((int)1), (BlockStateProvider)vines)), Direction.DOWN, BlockPredicate.f_190393_, true));
        ModConfiguredFeatures.register(context, HANGING_VIBRION_GEL, (HangingStringFeature)((Object)ModFeatures.HANGING_STRING.get()), new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.VIBRION_GEL.get()))));
        ModConfiguredFeatures.register(context, HANGING_LIT_VIBRION_GEL, (HangingStringFeature)((Object)ModFeatures.HANGING_STRING.get()), new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.LIT_VIBRION_GEL.get()))));
        ModConfiguredFeatures.register(context, LARGE_SUBSTILIUM_MUSHROOM, (LargeMushroomFeature)((Object)ModFeatures.LARGE_SUBSTILIUM_MUSHROOM.get()), new LargeMushroomConfiguration(6, 18, 3, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.ENTORIUM_SHROOM.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.SUBSTILIUM_STEM.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.SUBSTILIUM_WOOD.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.HANGING_VIBRION_VINES.get())), List.of(BlockStateProvider.m_191382_((Block)((Block)ModBlocks.SUBSTILIUM_SOIL.get()))), List.of(BlockStateProvider.m_191382_((Block)((Block)ModBlocks.VIBRION_BLOCK.get())), BlockStateProvider.m_191382_((Block)((Block)ModBlocks.VIBRION_GEL.get())), BlockStateProvider.m_191382_((Block)((Block)ModBlocks.LIT_VIBRION_GEL.get()))), Map.of(LargeMushroomCapShape.DOME, Float.valueOf(0.4f), LargeMushroomCapShape.FLAT, Float.valueOf(0.3f))));
        ModConfiguredFeatures.register(context, SPOTTED_EVERGREEN, Feature.f_65761_, new RandomPatchConfiguration(32, 16, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.SPOTTED_WINTERGREEN.get()))))));
        ModConfiguredFeatures.register(context, PINKSTER_FLOWER, Feature.f_65761_, new RandomPatchConfiguration(32, 16, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.PINKSTER_FLOWER.get()))))));
        for (HickoryColour colour : HickoryColour.values()) {
            ModConfiguredFeatures.registerHickoryTree(context, colour);
            ModConfiguredFeatures.registerHickorySapling(context, colour);
            ModConfiguredFeatures.registerHickoryBush(context, colour);
        }
        ModConfiguredFeatures.register(context, FALLEN_HICKORY_TREE, (FallenHickoryTreeFeature)((Object)ModFeatures.FALLEN_HICKORY_TREE.get()), new NoneFeatureConfiguration());
        ModConfiguredFeatures.register(context, EXTRA_TALL_GRASS, Feature.f_65763_, new RandomPatchConfiguration(32, 16, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50359_)))));
        ModConfiguredFeatures.register(context, EXTRA_FERNS, Feature.f_65763_, new RandomPatchConfiguration(32, 16, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50035_)))));
        ModConfiguredFeatures.register(context, EXTRA_TALL_FERNS, Feature.f_65763_, new RandomPatchConfiguration(32, 16, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50360_)))));
        ModConfiguredFeatures.register(context, PODZOL_VEIN, Feature.f_65731_, new OreConfiguration(podzol_vein, 32));
    }

    private static void registerHickoryTree(BootstapContext<ConfiguredFeature<?, ?>> context, HickoryColour colour) {
        ModConfiguredFeatures.register(context, HICKORY_TREES.get((Object)colour), Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.HICKORY_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(14, 2, 12), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.HICKORY_LEAVES_BLOCKS.get((Object)colour).get())), (FoliagePlacer)new HickoryTreeFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 15), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68249_((List)DECORATORS.get((Object)colour)).m_68251_());
    }

    private static void registerHickorySapling(BootstapContext<ConfiguredFeature<?, ?>> context, HickoryColour colour) {
        int count = colour == HickoryColour.HICKORY ? 32 : 16;
        ModConfiguredFeatures.register(context, HICKORY_SAPLINGS.get((Object)colour), Feature.f_65761_, new RandomPatchConfiguration(count, 16, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.HICKORY_SAPLINGS.get((Object)colour).get()))))));
    }

    private static void registerHickoryBush(BootstapContext<ConfiguredFeature<?, ?>> context, HickoryColour colour) {
        ModConfiguredFeatures.register(context, HICKORY_BUSHES.get((Object)colour), (HickoryBushFeature)((Object)ModFeatures.HICKORY_BUSH.get()), new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.HICKORY_LEAVES_BLOCKS.get((Object)colour).get()))));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("wildaside", name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    static {
        HICKORY_TREES.put(HickoryColour.HICKORY, HICKORY_TREE);
        HICKORY_TREES.put(HickoryColour.RED_GLOWING, RED_GLOWING_HICKORY_TREE);
        HICKORY_TREES.put(HickoryColour.BROWN_GLOWING, BROWN_GLOWING_HICKORY_TREE);
        HICKORY_TREES.put(HickoryColour.YELLOW_GLOWING, YELLOW_GLOWING_HICKORY_TREE);
        HICKORY_TREES.put(HickoryColour.GREEN_GLOWING, GREEN_GLOWING_HICKORY_TREE);
        HICKORY_SAPLINGS = new EnumMap(HickoryColour.class);
        HICKORY_SAPLINGS.put(HickoryColour.HICKORY, HICKORY_SAPLING);
        HICKORY_SAPLINGS.put(HickoryColour.RED_GLOWING, RED_GLOWING_HICKORY_SAPLING);
        HICKORY_SAPLINGS.put(HickoryColour.BROWN_GLOWING, BROWN_GLOWING_HICKORY_SAPLING);
        HICKORY_SAPLINGS.put(HickoryColour.YELLOW_GLOWING, YELLOW_GLOWING_HICKORY_SAPLING);
        HICKORY_SAPLINGS.put(HickoryColour.GREEN_GLOWING, GREEN_GLOWING_HICKORY_SAPLING);
        HICKORY_BUSHES = new EnumMap(HickoryColour.class);
        HICKORY_BUSHES.put(HickoryColour.HICKORY, HICKORY_BUSH);
        HICKORY_BUSHES.put(HickoryColour.RED_GLOWING, RED_GLOWING_HICKORY_BUSH);
        HICKORY_BUSHES.put(HickoryColour.BROWN_GLOWING, BROWN_GLOWING_HICKORY_BUSH);
        HICKORY_BUSHES.put(HickoryColour.YELLOW_GLOWING, YELLOW_GLOWING_HICKORY_BUSH);
        HICKORY_BUSHES.put(HickoryColour.GREEN_GLOWING, GREEN_GLOWING_HICKORY_BUSH);
        glowingBeehive = new BeehiveDecorator(0.0075f);
        hickoryDecorator = ImmutableList.of((Object)new BeehiveDecorator(0.007f), (Object)((Object)new FallenLeavesDecorator(0.075f, HickoryColour.HICKORY)));
        redGlowingHickoryDecorator = ImmutableList.of((Object)glowingBeehive, (Object)((Object)new FallenLeavesDecorator(0.075f, HickoryColour.RED_GLOWING)));
        brownGlowingHickoryDecorator = ImmutableList.of((Object)glowingBeehive, (Object)((Object)new FallenLeavesDecorator(0.075f, HickoryColour.BROWN_GLOWING)));
        yellowGlowingHickoryDecorator = ImmutableList.of((Object)glowingBeehive, (Object)((Object)new FallenLeavesDecorator(0.075f, HickoryColour.YELLOW_GLOWING)));
        greenGlowingHickoryDecorator = ImmutableList.of((Object)glowingBeehive, (Object)((Object)new FallenLeavesDecorator(0.075f, HickoryColour.GREEN_GLOWING)));
        DECORATORS = new EnumMap(HickoryColour.class);
        DECORATORS.put(HickoryColour.HICKORY, hickoryDecorator);
        DECORATORS.put(HickoryColour.RED_GLOWING, redGlowingHickoryDecorator);
        DECORATORS.put(HickoryColour.BROWN_GLOWING, brownGlowingHickoryDecorator);
        DECORATORS.put(HickoryColour.YELLOW_GLOWING, yellowGlowingHickoryDecorator);
        DECORATORS.put(HickoryColour.GREEN_GLOWING, greenGlowingHickoryDecorator);
    }
}

