/*
 * Decompiled with CFR 0.152.
 */
package net.farkas.wildaside.worldgen.feature.tree.hickory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.farkas.wildaside.worldgen.feature.ModFoliagePlacers;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import org.joml.Math;

public class HickoryTreeFoliagePlacer
extends FoliagePlacer {
    private final int height;
    public static final Codec<HickoryTreeFoliagePlacer> CODEC = RecordCodecBuilder.create(hickoryFoliagePlacerInstance -> HickoryTreeFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)hickoryFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)30).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)hickoryFoliagePlacerInstance, HickoryTreeFoliagePlacer::new));

    public HickoryTreeFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)ModFoliagePlacers.HICKORY_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        int breakPoint = Math.round((float)((float)pFoliageHeight * 0.35f));
        for (int i = -pFoliageHeight / 6; i < breakPoint; ++i) {
            int c = i + pFoliageHeight / 6;
            int radius = Math.round((float)((float)c / (float)breakPoint * (float)pFoliageRadius));
            if (radius > 1) {
                int xOff = pRandom.m_216332_(-1, 1);
                int zOff = pRandom.m_216332_(-1, 1);
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_().m_6625_(i), radius - 1, 0, pAttachment.m_68590_());
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_().m_6625_(i).m_7918_(xOff, 0, zOff), radius - 1, 0, pAttachment.m_68590_());
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_().m_6625_(i).m_7918_(-xOff, 0, -zOff), radius - 2, 0, pAttachment.m_68590_());
                continue;
            }
            this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_().m_6625_(i), radius, 0, pAttachment.m_68590_());
        }
        int m = pFoliageHeight - breakPoint;
        for (int i = breakPoint; i < pFoliageHeight; ++i) {
            int c = pFoliageHeight - i;
            int radius = Math.round((float)((float)c / (float)m * (float)pFoliageRadius));
            if (radius > 1) {
                int xOff = pRandom.m_216332_(-1, 1);
                int zOff = pRandom.m_216332_(-1, 1);
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_().m_6625_(i).m_7918_(xOff, 0, zOff), radius - 1, 0, pAttachment.m_68590_());
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_().m_6625_(i).m_7918_(-xOff, 0, -zOff), radius - 1, 0, pAttachment.m_68590_());
            } else {
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_().m_6625_(i), radius, 0, pAttachment.m_68590_());
            }
            this.m_272160_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_().m_6625_(i), radius, 0, pAttachment.m_68590_(), 0.5f, 0.25f);
        }
    }

    public int m_214116_(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return this.height;
    }

    protected boolean m_214203_(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return (pLocalX == pRange && pLocalZ == pRange && pRange > 0 || (pLocalX == pRange || pLocalZ == pRange) && pRange > 1) && pRandom.m_188501_() > 0.5f;
    }
}

