/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatstructures;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="compatstructures", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final Map<String, ForgeConfigSpec.BooleanValue> STRUCTURE_TOGGLES = new HashMap<String, ForgeConfigSpec.BooleanValue>();
    public static final Map<String, Boolean> ENABLED_STRUCTURES = new HashMap<String, Boolean>();
    private static ForgeConfigSpec.IntValue SPAWN_EXCLUSION_RADIUS;
    private static ForgeConfigSpec.IntValue SPAWN_SOFT_RADIUS;
    private static ForgeConfigSpec.DoubleValue BASE_SPAWN_CHANCE;
    private static final String[] STRUCTURE_KEYS;
    public static final ForgeConfigSpec SPEC;

    public static int spawnExclusionRadius() {
        return (Integer)SPAWN_EXCLUSION_RADIUS.get();
    }

    public static int spawnSoftRadius() {
        return (Integer)SPAWN_SOFT_RADIUS.get();
    }

    public static float baseSpawnChance() {
        return ((Double)BASE_SPAWN_CHANCE.get()).floatValue();
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() != SPEC) {
            return;
        }
        ENABLED_STRUCTURES.clear();
        for (String modId : STRUCTURE_KEYS) {
            ENABLED_STRUCTURES.put(modId, (Boolean)STRUCTURE_TOGGLES.get(modId).get());
        }
    }

    public static boolean isEnabled(String modId) {
        return ENABLED_STRUCTURES.getOrDefault(modId, true);
    }

    static {
        STRUCTURE_KEYS = new String[]{"ad_astra", "ae2", "aether", "alexscaves", "alexsmobs", "ars_nouveau", "artifacts", "biomesoplenty", "biomeswevegone", "botania", "create", "epicfight", "iceandfire", "immersiveengineering", "irons_spellbooks", "mowziesmobs", "naturalist", "quark", "tconstruct", "twilightforest"};
        BUILDER.comment(new String[]{"+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++", " CompatStructures", "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++", "Here you tweak how structures generate:", "  1. Kill off specific compat structures.", "  2. Control how far from spawn they can start dropping in.", "  3. Set spawn probability so your world doesn\u2019t get spammed.", "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"});
        BUILDER.push("spawn");
        BUILDER.comment(new String[]{" +++++++++++++++++ Hard Radius (Exclusion) +++++++++++++++++", "Inside this radius (in blocks) nothing spawns.", "Keeps the spawn zone clean, no mess right at world start.", "Example: 1500 = nothing within a 1.5k block radius."});
        SPAWN_EXCLUSION_RADIUS = BUILDER.defineInRange("exclusion_radius", 1500, 0, 100000);
        BUILDER.comment(new String[]{" +++++++++++++++++ Soft Ring (Soft Radius) +++++++++++++++++", "Outer radius of the soft ring.", "Inside this zone, spawn chance ramps from 0% (at exclusion_radius) up to base_chance (at soft_radius).", "Set it to 0 \u2192 soft ring disabled.", "Example: 2500 = transition zone between 1.5k and 2.5k blocks."});
        SPAWN_SOFT_RADIUS = BUILDER.defineInRange("soft_radius", 2500, 0, 100000);
        BUILDER.comment(new String[]{" +++++++++++++++++ Base Chance +++++++++++++++++", "Max spawn chance beyond the soft_radius.", "1.0 = always spawns, 0.35 = roughly 35% chance.", "Lower value = rarer structures, deal with it."});
        BASE_SPAWN_CHANCE = BUILDER.defineInRange("base_chance", 0.35, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("structures");
        for (String modId : STRUCTURE_KEYS) {
            STRUCTURE_TOGGLES.put(modId, BUILDER.comment("Enable generation for: " + modId).define("enable_" + modId, true));
        }
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

