/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatstructures;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="compatstructures", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final Map<String, ForgeConfigSpec.BooleanValue> STRUCTURE_TOGGLES = new HashMap<String, ForgeConfigSpec.BooleanValue>();
    public static final Map<String, Boolean> ENABLED_STRUCTURES = new HashMap<String, Boolean>();
    private static final String[] STRUCTURE_KEYS;
    public static final ForgeConfigSpec SPEC;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        ENABLED_STRUCTURES.clear();
        for (String modId : STRUCTURE_KEYS) {
            ENABLED_STRUCTURES.put(modId, (Boolean)STRUCTURE_TOGGLES.get(modId).get());
        }
    }

    public static boolean isEnabled(String modId) {
        return ENABLED_STRUCTURES.getOrDefault(modId, false);
    }

    static {
        for (String modId : STRUCTURE_KEYS = new String[]{"ad_astra", "ae2", "aether", "alexscaves", "alexsmobs", "ars_nouveau", "artifacts", "biomesoplenty", "biomeswevegone", "botania", "create", "epicfight", "iceandfire", "immersiveengineering", "irons_spellbooks", "mowziesmobs", "naturalist", "quark", "tconstruct", "twilightforest"}) {
            STRUCTURE_TOGGLES.put(modId, BUILDER.comment("Enable generation for: " + modId).define("enable_" + modId, true));
        }
        SPEC = BUILDER.build();
    }
}

