/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blockentity;

import com.tiviacz.pizzadelight.blockentity.BaseBlockEntity;
import com.tiviacz.pizzadelight.blockentity.content.BasinContent;
import com.tiviacz.pizzadelight.blockentity.content.BasinContentRegistry;
import com.tiviacz.pizzadelight.blockentity.content.BasinContentType;
import com.tiviacz.pizzadelight.init.ModBlockEntityTypes;
import com.tiviacz.pizzadelight.init.ModBlocks;
import com.tiviacz.pizzadelight.init.ModItems;
import com.tiviacz.pizzadelight.init.ModSounds;
import com.tiviacz.pizzadelight.tags.ModTags;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class BasinBlockEntity
extends BaseBlockEntity {
    public ItemStackHandler inventory = this.createHandler((NonNullList<ItemStack>)NonNullList.withSize((int)1, (Object)ItemStack.EMPTY));
    private BasinContent content = BasinContent.AIR;
    private int fermentProgress = 0;
    private final int defaultFermentTime = 1200;
    private static final String BASIN_CONTENT = "BasinContent";
    private static final String FERMENT_PROGRESS = "FermentProgress";

    public BasinBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.BASIN.get(), pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.inventory.deserializeNBT(pRegistries, compound.getCompound("Inventory"));
        this.content = BasinContentRegistry.REGISTRY.fromString(compound.getString(BASIN_CONTENT));
        this.fermentProgress = compound.getInt(FERMENT_PROGRESS);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(pRegistries));
        compound.putString(BASIN_CONTENT, this.content.toString());
        compound.putInt(FERMENT_PROGRESS, this.fermentProgress);
    }

    public BasinContent getBasinContent() {
        return this.content;
    }

    public ItemInteractionResult addMilk(Level level, @Nullable Player player, @Nullable InteractionHand hand) {
        this.content = BasinContent.MILK;
        if (player != null && !player.isCreative() && hand != null) {
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
        }
        level.playSound(player, this.getBlockPos(), SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 0.8f, 1.0f);
        this.setChanged();
        return ItemInteractionResult.SUCCESS;
    }

    public ItemInteractionResult removeMilk(ItemStack heldStack, Level level, Player player) {
        this.content = BasinContent.AIR;
        if (!player.isCreative()) {
            heldStack.shrink(1);
            if (!player.addItem(new ItemStack((ItemLike)Items.MILK_BUCKET))) {
                level.addFreshEntity((Entity)new ItemEntity(player.level(), (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), new ItemStack((ItemLike)Items.MILK_BUCKET)));
            }
        }
        this.resetFermenting();
        level.playSound(player, this.getBlockPos(), SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 0.8f, 1.0f);
        this.setChanged();
        return ItemInteractionResult.SUCCESS;
    }

    public ItemInteractionResult useFermentingItem(ItemStack heldStack, Level level, @Nullable Player player) {
        if (this.getBasinContent() == BasinContent.MILK && heldStack.is(ModTags.FERMENTING_ITEMS_TAG)) {
            level.playSound(player, this.getBlockPos(), SoundEvents.COMPOSTER_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player == null || !player.isCreative()) {
                heldStack.shrink(1);
            }
            this.content = BasinContent.FERMENTING_MILK;
            this.setChanged();
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult removeCheese(Level level, Player player) {
        if (this.getBasinContent() == BasinContent.CHEESE) {
            Direction direction = player.getDirection().getOpposite();
            ItemUtils.spawnItemEntity((Level)this.getLevel(), (ItemStack)ModBlocks.CHEESE_BLOCK.toStack(), (double)((double)this.getBlockPos().getX() + 0.5), (double)((double)this.getBlockPos().getY() + 0.3), (double)((double)this.getBlockPos().getZ() + 0.5), (double)((double)direction.getStepX() * 0.15), (double)0.05, (double)((double)direction.getStepZ() * 0.15));
            this.content = BasinContent.AIR;
            this.inventory.setStackInSlot(0, ItemStack.EMPTY);
            level.playSound(player, this.getBlockPos(), SoundEvents.FUNGUS_PLACE, SoundSource.BLOCKS, 0.8f, 0.9f + level.random.nextFloat());
            this.setChanged();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int getFermentProgress() {
        return this.fermentProgress;
    }

    public int getDefaultFermentTime() {
        return this.defaultFermentTime;
    }

    public int getComparatorOutput() {
        if (this.content == BasinContent.CHEESE) {
            return 15;
        }
        return 0;
    }

    public void finishFermenting() {
        if (this.getBasinContent().getContentType() == BasinContentType.FERMENTING_MILK) {
            this.fermentProgress = 0;
            this.content = BasinContent.CHEESE;
            this.inventory.setStackInSlot(0, ((Item)ModItems.CHEESE_BLOCK.get()).getDefaultInstance());
        }
        this.setChanged();
    }

    public void resetFermenting() {
        this.fermentProgress = 0;
        this.setChanged();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BasinBlockEntity blockEntity) {
        boolean save = false;
        if (blockEntity.getBasinContent() != null) {
            if (blockEntity.getBasinContent().getContentType() == BasinContentType.FERMENTING_MILK) {
                ++blockEntity.fermentProgress;
                save = true;
                if (level.random.nextDouble() < 0.005) {
                    level.playSound(null, pos, (SoundEvent)ModSounds.BLOCK_BASIN_FERMENTING.get(), SoundSource.BLOCKS, 0.8f, 0.9f + level.random.nextFloat());
                }
                if (level.random.nextDouble() < 0.05) {
                    blockEntity.createMilkParticles((float)blockEntity.getFermentProgress() / (float)blockEntity.getDefaultFermentTime());
                }
            }
            if (blockEntity.getFermentProgress() >= blockEntity.getDefaultFermentTime()) {
                blockEntity.finishFermenting();
            }
            if (blockEntity.getBasinContent().getContentType() == BasinContentType.CHEESE && level.random.nextDouble() < 0.05) {
                blockEntity.createCheeseParticle();
            }
        }
        if (save) {
            blockEntity.setChanged();
        }
    }

    private void createMilkParticles(float fermentProgress) {
        float[] milkColor = new float[]{1.0f, 1.0f, 1.0f};
        float[] cheeseColor = new float[]{0.91f, 0.76f, 0.31f};
        float[] currentColor = new float[3];
        for (int i = 0; i < 3; ++i) {
            currentColor[i] = (1.0f - fermentProgress) * milkColor[i] + fermentProgress * cheeseColor[i];
        }
        double x = (double)this.level.random.nextInt(12) / 16.0;
        double z = (double)this.level.random.nextInt(12) / 16.0;
        this.level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(currentColor[0], currentColor[1], currentColor[2]), 1.0f), (double)this.getBlockPos().getX() + x + 0.2, (double)this.getBlockPos().getY() + 0.6, (double)this.getBlockPos().getZ() + z + 0.2, 0.0, 0.09, 0.0);
    }

    private void createCheeseParticle() {
        double x = (double)this.level.random.nextInt(12) / 16.0;
        double z = (double)this.level.random.nextInt(12) / 16.0;
        this.level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.91f, 0.76f, 0.31f), 1.0f), (double)this.getBlockPos().getX() + x + 0.2, (double)this.getBlockPos().getY() + 0.6, (double)this.getBlockPos().getZ() + z + 0.2, 0.0, 0.09, 0.0);
    }

    private ItemStackHandler createHandler(NonNullList<ItemStack> contents) {
        return new ItemStackHandler(contents){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }

            protected void onContentsChanged(int slot) {
                if (this.getStackInSlot(slot).isEmpty()) {
                    BasinBlockEntity.this.content = BasinContent.AIR;
                }
                BasinBlockEntity.this.setChanged();
            }
        };
    }
}

