/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blocks;

import com.tiviacz.pizzadelight.blockentity.BasinBlockEntity;
import com.tiviacz.pizzadelight.blockentity.content.BasinContent;
import com.tiviacz.pizzadelight.init.ModBlockEntityTypes;
import com.tiviacz.pizzadelight.init.ModBlocks;
import com.tiviacz.pizzadelight.tags.ModTags;
import com.tiviacz.pizzadelight.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;

public class BasinBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = BasinBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);

    public BasinBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BasinBlockEntity) {
            BasinBlockEntity blockEntity2 = (BasinBlockEntity)blockEntity;
            if (stack.is(Tags.Items.BUCKETS_MILK) && blockEntity2.getBasinContent() == BasinContent.AIR) {
                return blockEntity2.addMilk(level, player, hand);
            }
            if (stack.is(ModTags.FERMENTING_ITEMS_TAG) && blockEntity2.getBasinContent() == BasinContent.MILK) {
                return blockEntity2.useFermentingItem(stack, level, player);
            }
            if (stack.is(Tags.Items.BUCKETS_EMPTY) && blockEntity2.getBasinContent() == BasinContent.MILK) {
                return blockEntity2.removeMilk(stack, level, player);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BasinBlockEntity blockEntity = (BasinBlockEntity)level.getBlockEntity(pos);
        if (level.isClientSide) {
            if (blockEntity.removeCheese(level, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return blockEntity.removeCheese(level, player);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof BasinBlockEntity) {
                BasinBlockEntity blockEntity2 = (BasinBlockEntity)blockEntity;
                if (blockEntity2.getBasinContent() == BasinContent.CHEESE) {
                    Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)ModBlocks.CHEESE_BLOCK.toStack());
                }
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BasinBlockEntity) {
            BasinBlockEntity blockEntity2 = (BasinBlockEntity)blockEntity;
            return blockEntity2.getComparatorOutput();
        }
        return 0;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BasinBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return Utils.getTicker(blockEntityType, (BlockEntityType)ModBlockEntityTypes.BASIN.get(), BasinBlockEntity::tick);
    }
}

