/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blocks;

import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.blocks.AbstractPizzaBlock;
import com.tiviacz.pizzadelight.blocks.PizzaBlock;
import com.tiviacz.pizzadelight.init.ModBlockEntityTypes;
import com.tiviacz.pizzadelight.init.ModSounds;
import com.tiviacz.pizzadelight.items.PizzaPeelItem;
import com.tiviacz.pizzadelight.util.RenderUtils;
import com.tiviacz.pizzadelight.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RawPizzaBlock
extends AbstractPizzaBlock {
    public RawPizzaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        PizzaBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof PizzaBlockEntity && (blockEntity = (PizzaBlockEntity)blockEntity2).isBaking()) {
            if (rand.nextDouble() < 0.3) {
                level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)ModSounds.BLOCK_PIZZA_SIZZLING.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (rand.nextDouble() > 0.5) {
                double[] particlePos = RenderUtils.getPosRandomAboveBlockHorizontal(level, pos);
                level.addParticle((ParticleOptions)ParticleTypes.POOF, particlePos[0], (double)pos.getY() + 0.4, particlePos[1], 0.0, 0.025, 0.0);
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemInteractionResult itemInteractionResult;
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.getItem() instanceof PizzaPeelItem) {
            itemInteractionResult = this.pickUpPizza(level, pos, state, player.getDirection().getOpposite());
        } else {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof PizzaBlockEntity) {
                PizzaBlockEntity pizzaBLockEntity = (PizzaBlockEntity)blockEntity;
                itemInteractionResult = pizzaBLockEntity.manageIngredients(player, hand);
            } else {
                itemInteractionResult = ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        return itemInteractionResult;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PizzaBlockEntity) {
            PizzaBlockEntity blockEntity2 = (PizzaBlockEntity)blockEntity;
            if (!player.isCreative() && !(player.getMainHandItem().getItem() instanceof PizzaPeelItem)) {
                for (int i = 0; i < blockEntity2.getInventory().getSlots(); ++i) {
                    if (blockEntity2.getInventory().getStackInSlot(i).isEmpty()) continue;
                    Utils.spawnItemStackInWorld(level, pos, blockEntity2.getInventory().getStackInSlot(i));
                    blockEntity2.getInventory().setStackInSlot(i, ItemStack.EMPTY);
                }
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.getBlock() instanceof PizzaBlock)) {
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return Utils.getTicker(blockEntityType, (BlockEntityType)ModBlockEntityTypes.PIZZA.get(), PizzaBlockEntity::tick);
    }
}

