/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blocks.dispenser;

import com.tiviacz.pizzadelight.blockentity.BasinBlockEntity;
import com.tiviacz.pizzadelight.blockentity.content.BasinContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class BasinDispenserBehaviour {

    public static class Fermenting
    extends DefaultDispenseItemBehavior {
        public ItemStack execute(BlockSource source, ItemStack stack) {
            BasinBlockEntity basinBlockEntity;
            BlockPos blockpos;
            ServerLevel level = source.level();
            BlockEntity blockEntity = level.getBlockEntity(blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING)));
            if (blockEntity instanceof BasinBlockEntity && (basinBlockEntity = (BasinBlockEntity)blockEntity).getBasinContent() == BasinContent.MILK) {
                basinBlockEntity.useFermentingItem(stack, (Level)level, null);
                return stack;
            }
            return stack;
        }
    }

    public static class Milk
    extends DefaultDispenseItemBehavior {
        public ItemStack execute(BlockSource source, ItemStack stack) {
            BasinBlockEntity basinBlockEntity;
            BlockPos blockpos;
            ServerLevel level = source.level();
            BlockEntity blockEntity = level.getBlockEntity(blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING)));
            if (blockEntity instanceof BasinBlockEntity && (basinBlockEntity = (BasinBlockEntity)blockEntity).getBasinContent() == BasinContent.AIR) {
                basinBlockEntity.addMilk((Level)level, null, null);
                return new ItemStack((ItemLike)Items.BUCKET);
            }
            return stack;
        }
    }
}

