/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blocks.dispenser;

import com.tiviacz.pizzadelight.blocks.AbstractPizzaBlock;
import com.tiviacz.pizzadelight.blocks.PizzaBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PizzaDispenserBehaviour {

    public static class Pickup
    extends DefaultDispenseItemBehavior {
        protected ItemStack execute(BlockSource pSource, ItemStack pStack) {
            ServerLevel serverlevel = pSource.level();
            if (!serverlevel.isClientSide()) {
                Direction facing = (Direction)pSource.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockpos = pSource.pos().relative(facing);
                boolean success = Pickup.tryPickupPizza(serverlevel, blockpos, facing);
                if (success) {
                    pStack.hurtAndBreak(1, serverlevel, null, param -> {});
                }
            }
            return pStack;
        }

        private static boolean tryPickupPizza(ServerLevel level, BlockPos pos, Direction direction) {
            BlockState blockstate = level.getBlockState(pos);
            Block block = blockstate.getBlock();
            if (block instanceof AbstractPizzaBlock) {
                AbstractPizzaBlock abstractPizzaBlock = (AbstractPizzaBlock)block;
                abstractPizzaBlock.pickUpPizza((Level)level, pos, blockstate, direction);
                return true;
            }
            return false;
        }
    }

    public static class CutSlice
    extends DefaultDispenseItemBehavior {
        protected ItemStack execute(BlockSource pSource, ItemStack pStack) {
            ServerLevel serverlevel = pSource.level();
            if (!serverlevel.isClientSide()) {
                Direction facing = (Direction)pSource.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockpos = pSource.pos().relative(facing);
                boolean success = CutSlice.tryCutSlice(serverlevel, blockpos, facing);
                if (success) {
                    pStack.hurtAndBreak(1, serverlevel, null, param -> {});
                }
            }
            return pStack;
        }

        private static boolean tryCutSlice(ServerLevel level, BlockPos pos, Direction direction) {
            BlockState blockstate = level.getBlockState(pos);
            Block block = blockstate.getBlock();
            if (block instanceof PizzaBlock) {
                PizzaBlock pizzaBlock = (PizzaBlock)block;
                pizzaBlock.cutSlice((Level)level, pos, blockstate, direction);
                return true;
            }
            return false;
        }
    }
}

