/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.client.gui;

import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.client.gui.ScreenPizzaStation;
import com.tiviacz.pizzadelight.client.tooltip.IngredientsTooltip;
import com.tiviacz.pizzadelight.container.PizzaMenu;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenPizza
extends AbstractContainerScreen<PizzaMenu>
implements MenuAccess<PizzaMenu> {
    public static final ResourceLocation SCREEN_PIZZA = ResourceLocation.fromNamespaceAndPath((String)"pizzadelight", (String)"textures/gui/pizza.png");
    private final ScreenImage HUNGER_INFO = new ScreenImage(126, 40, 13, 13);
    private final PizzaBlockEntity blockEntity;
    private final CyclingSlotBackground sauceIcon = new CyclingSlotBackground(10);
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.00");

    public ScreenPizza(PizzaMenu menu, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)menu, inv, titleIn);
        this.blockEntity = menu.blockEntity;
        this.leftPos = 0;
        this.topPos = 0;
        this.imageWidth = 176;
        this.imageHeight = 158;
        this.inventoryLabelY -= 6;
    }

    public void containerTick() {
        super.containerTick();
        this.sauceIcon.tick(ScreenPizzaStation.SAUCES);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.blockEntity.getDisplayName(), this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    public List<Component> getTooltip() {
        ArrayList<Component> components = new ArrayList<Component>();
        if (!this.blockEntity.getInventory().getStackInSlot(9).isEmpty()) {
            // empty if block
        }
        components.add((Component)Component.translatable((String)"information.pizzadelight.view_recommended_ingredients"));
        return components;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.HUNGER_INFO.inButton(this, mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, this.getTooltip(), Optional.of(new IngredientsTooltip()), mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(SCREEN_PIZZA, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.sauceIcon.render(this.menu, guiGraphics, partialTicks, this.leftPos, this.topPos);
    }

    public static class ScreenImage {
        private final int X;
        private final int Y;
        private final int W;
        private final int H;

        public ScreenImage(int U, int V, int W, int H) {
            this.X = U;
            this.Y = V;
            this.W = W;
            this.H = H;
        }

        public boolean inButton(ScreenPizza screen, int mouseX, int mouseY) {
            return this.X <= (mouseX -= screen.getGuiLeft()) && mouseX <= this.X + this.W && this.Y <= (mouseY -= screen.getGuiTop()) && mouseY <= this.Y + this.H;
        }
    }
}

