/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.pizzadelight.blockentity.PizzaStationBlockEntity;
import com.tiviacz.pizzadelight.client.tooltip.IngredientsTooltip;
import com.tiviacz.pizzadelight.container.PizzaStationMenu;
import com.tiviacz.pizzadelight.network.ServerboundRenamePizzaPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class ScreenPizzaStation
extends AbstractContainerScreen<PizzaStationMenu>
implements MenuAccess<PizzaStationMenu>,
ContainerListener {
    public static final ResourceLocation SCREEN_PIZZA_STATION = ResourceLocation.fromNamespaceAndPath((String)"pizzadelight", (String)"textures/gui/pizza_station.png");
    private static final ResourceLocation EMPTY_SLOT_SAUCE = ResourceLocation.fromNamespaceAndPath((String)"pizzadelight", (String)"item/empty_slot_sauce");
    private static final ResourceLocation EMPTY_SLOT_POTION = ResourceLocation.fromNamespaceAndPath((String)"pizzadelight", (String)"item/empty_slot_potion");
    private static final ResourceLocation EMPTY_SLOT_RAW_PIZZA = ResourceLocation.fromNamespaceAndPath((String)"pizzadelight", (String)"item/empty_slot_raw_pizza");
    public static final List<ResourceLocation> SAUCES = List.of(EMPTY_SLOT_SAUCE, EMPTY_SLOT_POTION);
    private static final List<ResourceLocation> DOUGH = List.of(EMPTY_SLOT_RAW_PIZZA);
    private final PizzaStationBlockEntity blockEntity;
    private EditBox name;
    public final CyclingSlotBackground sauceIcon = new CyclingSlotBackground(2);
    private final CyclingSlotBackground doughIcon = new CyclingSlotBackground(1);

    public ScreenPizzaStation(PizzaStationMenu menu, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)menu, inv, titleIn);
        this.blockEntity = menu.blockEntity;
        this.leftPos = 0;
        this.topPos = 0;
        this.titleLabelX = 55;
        this.titleLabelY = 6;
        this.imageWidth = 176;
        this.imageHeight = 196;
        this.inventoryLabelY += 31;
    }

    public void containerTick() {
        super.containerTick();
        this.sauceIcon.tick(SAUCES);
        this.doughIcon.tick(DOUGH);
    }

    public void init() {
        super.init();
        this.subInit();
        ((PizzaStationMenu)this.menu).addSlotListener(this);
    }

    protected void subInit() {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.name = new EditBox(this.font, i + 57, j + 24, 98, 12, this.blockEntity.getDisplayName());
        this.name.setCanLoseFocus(true);
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setBordered(false);
        this.name.setMaxLength(50);
        this.name.setResponder(this::onNameChanged);
        this.name.setValue("");
        this.addWidget((GuiEventListener)this.name);
        this.name.setEditable(false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.disableBlend();
        this.renderFg(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.renderTooltip(pGuiGraphics, pX, pY);
        if (this.getGuiLeft() + 116 <= pX && pX <= this.getGuiLeft() + 22 + 116 && this.getGuiTop() + 66 <= pY && pY <= this.getGuiTop() + 15 + 66) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            components.add(Component.translatable((String)"information.pizzadelight.view_recommended_ingredients"));
            pGuiGraphics.renderTooltip(this.font, components, Optional.of(new IngredientsTooltip()), pX, pY);
        }
    }

    public void renderFg(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.name.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(SCREEN_PIZZA_STATION, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.sauceIcon.render(this.menu, guiGraphics, partialTicks, this.leftPos, this.topPos);
        this.doughIcon.render(this.menu, guiGraphics, partialTicks, this.leftPos, this.topPos);
    }

    public void resize(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.name.getValue();
        this.init(pMinecraft, pWidth, pHeight);
        this.name.setValue(s);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return this.name.keyPressed(pKeyCode, pScanCode, pModifiers) || this.name.canConsumeInput() || super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    private void onNameChanged(String name) {
        Slot slot = ((PizzaStationMenu)this.menu).getSlot(0);
        if (slot.hasItem()) {
            String s = name;
            if (!slot.getItem().has(DataComponents.CUSTOM_NAME) && name.equals(slot.getItem().getHoverName().getString())) {
                s = "";
            }
            if (((PizzaStationMenu)this.menu).setItemName(s)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundRenamePizzaPacket(s), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void removed() {
        super.removed();
        ((PizzaStationMenu)this.menu).removeSlotListener(this);
    }

    public void slotChanged(AbstractContainerMenu pContainerToSend, int pSlotInd, ItemStack pStack) {
        if (pSlotInd == 0) {
            this.name.setValue(pStack.isEmpty() ? "" : pStack.getHoverName().getString());
            this.name.setEditable(!pStack.isEmpty());
        }
    }

    public void dataChanged(AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
    }
}

