/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.pizzadelight.blockentity.BasinBlockEntity;
import com.tiviacz.pizzadelight.blockentity.content.BasinContent;
import com.tiviacz.pizzadelight.blockentity.content.BasinContentType;
import java.util.Random;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class BasinRenderer
implements BlockEntityRenderer<BasinBlockEntity> {
    private static final ResourceLocation MILK_TEX = ResourceLocation.fromNamespaceAndPath((String)"pizzadelight", (String)"textures/block/milk.png");
    private static final ResourceLocation CHEESE_TEX = ResourceLocation.fromNamespaceAndPath((String)"pizzadelight", (String)"textures/block/cheese.png");
    private final Random rand = new Random();
    protected ContentModel cheese;
    protected ContentModel milk;
    protected ContentModel model;

    public BasinRenderer(BlockEntityRendererProvider.Context context) {
        this.cheese = new ContentModel(context);
        this.milk = new ContentModel(context);
        this.model = new ContentModel(context);
    }

    public void render(BasinBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.rand.setSeed(42L);
        ResourceLocation tex = this.getTexture(blockEntity.getBasinContent());
        BasinContent basinContent = blockEntity.getBasinContent();
        poseStack.pushPose();
        if (basinContent.getContentType() == BasinContentType.FERMENTING_MILK || basinContent.getContentType() == BasinContentType.MILK) {
            float progressToFloatInv = 1.0f - (float)blockEntity.getFermentProgress() / (float)blockEntity.getDefaultFermentTime();
            this.cheese.renderToBuffer(poseStack, bufferIn.getBuffer(RenderType.entitySolid((ResourceLocation)CHEESE_TEX)), combinedLightIn, combinedOverlayIn, -1);
            this.milk.renderToBuffer(poseStack, bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)MILK_TEX)), combinedLightIn, combinedOverlayIn, FastColor.ARGB32.colorFromFloat((float)progressToFloatInv, (float)1.0f, (float)1.0f, (float)1.0f));
        }
        if (basinContent.getContentType() == BasinContentType.CHEESE) {
            this.model.renderToBuffer(poseStack, bufferIn.getBuffer(RenderType.entitySolid((ResourceLocation)tex)), combinedLightIn, combinedOverlayIn, -1);
        }
        poseStack.popPose();
    }

    public ResourceLocation getTexture(BasinContent content) {
        return switch (content.getContentType()) {
            case BasinContentType.MILK, BasinContentType.FERMENTING_MILK -> MILK_TEX;
            case BasinContentType.CHEESE -> CHEESE_TEX;
            default -> MissingTextureAtlasSprite.getLocation();
        };
    }

    public static class ContentModel
    extends Model {
        public static final ResourceLocation CONTENT = ResourceLocation.fromNamespaceAndPath((String)"pizzadelight", (String)"content");
        public static final ModelLayerLocation CONTENT_LAYER = new ModelLayerLocation(CONTENT, "main");
        private final ModelPart content;

        public ContentModel(BlockEntityRendererProvider.Context context) {
            super(RenderType::entitySolid);
            this.content = context.getModelSet().bakeLayer(CONTENT_LAYER).getChild("main");
        }

        public void renderToBuffer(PoseStack poseStack, VertexConsumer bufferIn, int pPackedLight, int pPackedOverlay, int pColor) {
            this.content.render(poseStack, bufferIn, pPackedLight, pPackedOverlay, pColor);
        }

        public static LayerDefinition createModelData() {
            MeshDefinition mesh = new MeshDefinition();
            mesh.getRoot().addOrReplaceChild("main", CubeListBuilder.create().addBox(2.0f, 1.0f, 2.0f, 12.0f, 6.0f, 12.0f), PartPose.ZERO);
            return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
        }
    }
}

