/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.client.PizzaBakedModel;
import com.tiviacz.pizzadelight.init.ModBlocks;
import com.tiviacz.pizzadelight.util.BlockAlphaRenderer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.data.ModelData;

public class PizzaRenderer
implements BlockEntityRenderer<PizzaBlockEntity> {
    public PizzaRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PizzaBlockEntity tileEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntityIn.isBaking()) {
            this.renderPizzaBakingProcess(tileEntityIn, poseStack, bufferIn);
        }
    }

    public void renderPizzaBakingProcess(PizzaBlockEntity tileEntity, PoseStack poseStack, MultiBufferSource bufferIn) {
        poseStack.pushPose();
        poseStack.translate(-0.0025, 0.0, -0.0025);
        poseStack.scale(1.005f, 1.005f, 1.005f);
        ModelData modelData = tileEntity.getModelData();
        modelData.derive().with(PizzaBakedModel.IS_RAW, Optional.of(false));
        BlockAlphaRenderer.renderBlockAlpha(tileEntity.getBlockPos(), ((Block)ModBlocks.PIZZA.get()).defaultBlockState(), tileEntity.getLevel(), poseStack, bufferIn, modelData);
        poseStack.popPose();
    }
}

