/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.container;

import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.init.ModMenuTypes;
import com.tiviacz.pizzadelight.tags.ModTags;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class PizzaMenu
extends AbstractContainerMenu {
    public Inventory inv;
    public PizzaBlockEntity blockEntity;
    public ItemStackHandler transistentHandler = this.createTransistentHandler();

    public PizzaMenu(int windowID, Inventory inv, FriendlyByteBuf data) {
        this(windowID, inv, PizzaMenu.getBlockEntity(inv, data));
    }

    public PizzaMenu(int windowID, Inventory inv, BlockEntity tile) {
        super((MenuType)ModMenuTypes.PIZZA.get(), windowID);
        this.inv = inv;
        this.blockEntity = (PizzaBlockEntity)tile;
        this.addIngredientsSlots();
        this.addSauceSlot();
        this.addTransistentSlots();
        this.addPlayerInventoryAndHotbar(inv);
    }

    public void addPlayerInventoryAndHotbar(Inventory inv) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inv, x + y * 9 + 9, 8 + x * 18, 76 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inv, x, 8 + x * 18, 134));
        }
    }

    public void addTransistentSlots() {
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.transistentHandler, 0, 35, 10){

            public int getMaxStackSize(@Nonnull ItemStack stack) {
                return 1;
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.transistentHandler, 1, 35, 46){

            public int getMaxStackSize(@Nonnull ItemStack stack) {
                return 1;
            }
        });
    }

    public void addIngredientsSlots() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.getInventory(), j + i * 3, 62 + j * 18, 10 + i * 18){

                    public int getMaxStackSize(@Nonnull ItemStack stack) {
                        return 1;
                    }
                });
            }
        }
    }

    public void addSauceSlot() {
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.getInventory(), 9, 125, 20){

            public int getMaxStackSize(@Nonnull ItemStack stack) {
                return 1;
            }

            public boolean mayPickup(Player playerIn) {
                return false;
            }

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }
        });
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 12 ? !this.moveItemStackTo(itemstack1, 12, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 12, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, this.transistentHandler);
    }

    protected void clearContainer(Player player, ItemStackHandler handler) {
        if (!player.isAlive() || player instanceof ServerPlayer && ((ServerPlayer)player).hasDisconnected()) {
            for (int j = 0; j < handler.getSlots(); ++j) {
                ItemStack stack = handler.getStackInSlot(j).copy();
                player.drop(stack, false);
            }
        } else {
            for (int i = 0; i < handler.getSlots(); ++i) {
                Inventory inventory = player.getInventory();
                if (!(inventory.player instanceof ServerPlayer)) continue;
                ItemStack stack = handler.getStackInSlot(i).copy();
                inventory.placeItemBackInInventory(stack);
            }
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    private static PizzaBlockEntity getBlockEntity(Inventory inv, FriendlyByteBuf data) {
        Objects.requireNonNull(inv, "inv cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockEntity = inv.player.level().getBlockEntity(data.readBlockPos());
        if (blockEntity instanceof PizzaBlockEntity) {
            return (PizzaBlockEntity)blockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(blockEntity));
    }

    private ItemStackHandler createTransistentHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                PizzaMenu.this.transferStack();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.getItem() instanceof PotionItem || stack.is(ModTags.SAUCE);
            }
        };
    }

    private void transferStack() {
        if (!this.transistentHandler.getStackInSlot(0).isEmpty()) {
            ItemStack sauceStack = this.transistentHandler.getStackInSlot(0);
            ItemStack container = PizzaMenu.getItemStack(sauceStack);
            this.blockEntity.getInventory().setStackInSlot(9, sauceStack);
            this.transistentHandler.setStackInSlot(0, ItemStack.EMPTY);
            this.blockEntity.setChanged();
            this.transistentHandler.setStackInSlot(1, container);
        }
    }

    public static ItemStack getItemStack(ItemStack sauceStack) {
        boolean isSauce;
        ItemStack container = sauceStack.getCraftingRemainingItem();
        boolean isPotion = sauceStack.getItem() instanceof PotionItem;
        boolean bl = isSauce = sauceStack.has(DataComponents.FOOD) && !((FoodProperties)sauceStack.get(DataComponents.FOOD)).usingConvertsTo().isEmpty();
        if (container.isEmpty()) {
            if (isPotion) {
                container = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            } else if (isSauce) {
                container = (ItemStack)((FoodProperties)sauceStack.get(DataComponents.FOOD)).usingConvertsTo().get();
            }
        }
        return container;
    }
}

