/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.handlers;

import com.tiviacz.pizzadelight.blockentity.BasinBlockEntity;
import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.components.PizzaIngredients;
import com.tiviacz.pizzadelight.init.ModBlockEntityTypes;
import com.tiviacz.pizzadelight.init.ModBlocks;
import com.tiviacz.pizzadelight.init.ModDataComponents;
import com.tiviacz.pizzadelight.init.ModNetwork;
import com.tiviacz.pizzadelight.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@EventBusSubscriber(modid="pizzadelight", bus=EventBusSubscriber.Bus.MOD)
public class ModEventHandler {
    @SubscribeEvent
    public static void registerPayloadHandler(RegisterPayloadHandlersEvent event) {
        ModNetwork.register(event.registrar("pizzadelight"));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerBlockItemColors(RegisterColorHandlersEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        blockColors.register((state, world, pos, tintIndex) -> {
            BlockEntity blockEntity;
            ItemStackHandler handler = new ItemStackHandler(12);
            boolean isRaw = true;
            if (world != null && (blockEntity = world.getBlockEntity(pos)) instanceof PizzaBlockEntity) {
                PizzaBlockEntity be = (PizzaBlockEntity)blockEntity;
                handler = be.inventory;
                isRaw = be.isRaw();
            }
            int color = RenderUtils.getDominantColor(Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(handler.getStackInSlot(tintIndex)).getParticleIcon(), isRaw);
            if (handler.getStackInSlot(tintIndex).has(DataComponents.POTION_CONTENTS)) {
                PotionContents contents = (PotionContents)handler.getStackInSlot(tintIndex).getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
                color = contents.getColor();
            }
            if (handler.getStackInSlot(tintIndex).isEmpty()) {
                return 14858625;
            }
            return color;
        }, new Block[]{(Block)ModBlocks.RAW_PIZZA.get(), (Block)ModBlocks.PIZZA.get()});
        itemColors.register((stack, tintIndex) -> {
            NonNullList<ItemStack> ingredients = ((PizzaIngredients)stack.getOrDefault(ModDataComponents.PIZZA_INGREDIENTS, (Object)PizzaIngredients.EMPTY)).getIngredients();
            int color = RenderUtils.getDominantColor(Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel((ItemStack)ingredients.get(tintIndex)).getParticleIcon(), stack.getItem() == ((Block)ModBlocks.RAW_PIZZA.get()).asItem());
            if (((ItemStack)ingredients.get(tintIndex)).has(DataComponents.POTION_CONTENTS)) {
                PotionContents contents = (PotionContents)((ItemStack)ingredients.get(tintIndex)).getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
                color = contents.getColor();
            }
            if (((ItemStack)ingredients.get(tintIndex)).isEmpty()) {
                return 14858625;
            }
            return color;
        }, new ItemLike[]{(ItemLike)ModBlocks.RAW_PIZZA.get(), (ItemLike)ModBlocks.PIZZA.get()});
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.PIZZA.get(), (blockEntity, side) -> {
            if (blockEntity instanceof PizzaBlockEntity) {
                PizzaBlockEntity pizzaBlockEntity = blockEntity;
                return pizzaBlockEntity.inventory;
            }
            return new ItemStackHandler(0);
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.BASIN.get(), (blockEntity, side) -> {
            if (blockEntity instanceof BasinBlockEntity) {
                BasinBlockEntity basinBlockEntity = blockEntity;
                return basinBlockEntity.inventory;
            }
            return new ItemStackHandler(0);
        });
    }
}

