/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.items;

import com.tiviacz.pizzadelight.client.tooltip.PizzaTooltipComponent;
import com.tiviacz.pizzadelight.common.PizzaBlockCalculator;
import com.tiviacz.pizzadelight.components.PizzaIngredients;
import com.tiviacz.pizzadelight.init.ModDataComponents;
import com.tiviacz.pizzadelight.util.PizzaFoodBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class PizzaSliceItem
extends Item {
    public PizzaSliceItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        if (pStack.has(DataComponents.FOOD) && !this.getFoodProperties(pStack, null).effects().isEmpty()) {
            TextUtils.addFoodEffectTooltip((ItemStack)pStack, pTooltipComponents::add, (float)1.0f, (float)pContext.tickRate());
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        return Optional.of(new PizzaTooltipComponent(pStack));
    }

    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        FoodProperties foodProperties = (FoodProperties)stack.get(DataComponents.FOOD);
        if (foodProperties == null) {
            return null;
        }
        if (!foodProperties.canAlwaysEat()) {
            return foodProperties;
        }
        PizzaFoodBuilder newProps = new PizzaFoodBuilder().nutrition(foodProperties.nutrition()).saturationModifier(foodProperties.saturation()).alwaysEdible();
        if (stack.has(ModDataComponents.PIZZA_INGREDIENTS)) {
            PizzaBlockCalculator calculator = new PizzaBlockCalculator(new ItemStackHandler(((PizzaIngredients)stack.get(ModDataComponents.PIZZA_INGREDIENTS)).getIngredients()));
            List<FoodProperties.PossibleEffect> effects = calculator.findEffects();
            for (FoodProperties.PossibleEffect effect : effects) {
                newProps.effect(effect.effectSupplier(), effect.probability());
            }
        }
        return newProps.build();
    }
}

