/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class BlockAlphaRenderer
extends ModelBlockRenderer {
    private static BlockAlphaRenderer INSTANCE;

    public static BlockAlphaRenderer getInstance(ModelBlockRenderer baseRenderer) {
        if (INSTANCE == null || BlockAlphaRenderer.INSTANCE.blockColors != baseRenderer.blockColors) {
            INSTANCE = new BlockAlphaRenderer(baseRenderer);
        }
        return INSTANCE;
    }

    public BlockAlphaRenderer(ModelBlockRenderer baseRenderer) {
        super(baseRenderer.blockColors);
    }

    public static void renderBlockAlpha(BlockPos pos, BlockState state, Level level, PoseStack poseStack, MultiBufferSource buffer, ModelData data) {
        poseStack.pushPose();
        BlockRenderDispatcher blockDispatcher = Minecraft.getInstance().getBlockRenderer();
        BlockAlphaRenderer renderer = BlockAlphaRenderer.getInstance(blockDispatcher.getModelRenderer());
        renderer.tesselateBlock((BlockAndTintGetter)level, blockDispatcher.getBlockModel(state), state, pos, poseStack, buffer.getBuffer(RenderType.translucent()), false, level.random, state.getSeed(pos), OverlayTexture.NO_OVERLAY, data, null);
        poseStack.popPose();
    }

    public void putQuadData(BlockAndTintGetter level, BlockState state, BlockPos pos, VertexConsumer vertexConsumer, PoseStack.Pose pose, BakedQuad quad, float tintA, float tintB, float tintC, float tintD, int brightness0, int brightness1, int brightness2, int brightness3, int combinedOverlayIn) {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (quad.isTinted()) {
            int i = this.blockColors.getColor(state, level, pos, quad.getTintIndex());
            r = (float)(i >> 16 & 0xFF) / 255.0f;
            g = (float)(i >> 8 & 0xFF) / 255.0f;
            b = (float)(i & 0xFF) / 255.0f;
        }
        float alpha = 1.0f;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PizzaBlockEntity) {
            PizzaBlockEntity tileEntity = (PizzaBlockEntity)blockEntity;
            alpha = (float)tileEntity.getBakingTime() / (float)tileEntity.getCalculatedBakingTime();
        }
        vertexConsumer.putBulkData(pose, quad, new float[]{tintA, tintB, tintC, tintD}, r, g, b, alpha, new int[]{brightness0, brightness1, brightness2, brightness3}, combinedOverlayIn, true);
    }
}

