/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.commands;

import com.fibermc.essentialcommands.ECPerms;
import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.ManagerLocator;
import com.fibermc.essentialcommands.commands.helpers.HeightFinder;
import com.fibermc.essentialcommands.commands.helpers.HeightFindingStrategy;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.teleportation.PlayerTeleporter;
import com.fibermc.essentialcommands.text.ECText;
import com.fibermc.essentialcommands.text.TextFormatType;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.RtpCenter;
import com.fibermc.essentialcommands.types.Vec2i;
import com.google.common.base.Stopwatch;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jpcode.eccore.util.TextUtil;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class RandomTeleportCommand
implements Command<class_2168> {
    private final Thread.UncaughtExceptionHandler exceptionHandler = (thread, throwable) -> EssentialCommands.LOGGER.error("Exception in RTP calculator thread", throwable);
    private final Executor threadExecutor = Executors.newCachedThreadPool(runnable -> {
        Thread thread = new Thread(runnable, "RTP Location Calculator Thread");
        thread.setUncaughtExceptionHandler(this.exceptionHandler);
        return thread;
    });

    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        ECText ecText = ECText.access(player);
        if (!EssentialCommands.CONFIG.RTP_ENABLED_WORLDS.contains(world.method_27983())) {
            class_2561 currentWorldAsText = class_2561.method_30163((String)world.method_27983().method_29177().toString());
            PlayerData.access(player).sendCommandError((class_2561)TextUtil.concat((class_2561[])new class_2561[]{ecText.getText("cmd.rtp.error.pre", TextFormatType.Error, new class_2561[0]), ecText.getText("cmd.rtp.error.world_not_enabled", TextFormatType.Error, currentWorldAsText)}));
            return 0;
        }
        if (EssentialCommands.CONFIG.RTP_COOLDOWN > 0 && !ECPerms.check((class_2168)context.getSource(), "essentialcommands.bypass.randomteleport_cooldown")) {
            int curServerTickTime = ((class_2168)context.getSource()).method_9211().method_3780();
            PlayerData playerData = PlayerData.access(player);
            int rtpCooldownEndTime = playerData.getTimeUsedRtp() + EssentialCommands.CONFIG.RTP_COOLDOWN * 20;
            int rtpCooldownRemaining = rtpCooldownEndTime - curServerTickTime;
            if (rtpCooldownRemaining > 0) {
                playerData.sendError("cmd.rtp.error.cooldown", new class_2561[]{ecText.accent(String.format("%.1f", (double)rtpCooldownRemaining / 20.0))});
                return 0;
            }
            playerData.setTimeUsedRtp(curServerTickTime);
        }
        this.threadExecutor.execute(() -> {
            EssentialCommands.LOGGER.info("Starting RTP location search for {}", (Object)player.method_7334().name());
            Stopwatch timer = Stopwatch.createStarted();
            RandomTeleportCommand.exec(player, world);
            Stopwatch totalTime = timer.stop();
            EssentialCommands.LOGGER.info("Total RTP Time: {}", (Object)totalTime);
        });
        return 1;
    }

    private static void exec(class_3222 player, class_3218 world) {
        Optional<class_2338> pos;
        Optional<class_2382> centerOpt = RandomTeleportCommand.getRtpCenter(player);
        if (centerOpt.isEmpty()) {
            return;
        }
        class_2382 center = centerOpt.get();
        ExecutionContext executionContext = new ExecutionContext(world);
        HeightFindingStrategy heightFinder = HeightFindingStrategy.forWorld((class_5321<class_1937>)world.method_27983());
        int timesRun = 0;
        while ((pos = RandomTeleportCommand.findRtpPosition(world, center, heightFinder, executionContext)).isEmpty() && ++timesRun <= EssentialCommands.CONFIG.RTP_MAX_ATTEMPTS) {
        }
        if (pos.isEmpty()) {
            return;
        }
        PlayerTeleporter.requestTeleport(player, new MinecraftLocation((class_5321<class_1937>)world.method_27983(), (class_2382)pos.get(), 0.0f, 0.0f), ECText.access(player).getText("cmd.rtp.location_name", new class_2561[0]));
    }

    private static Optional<class_2382> getRtpCenter(class_3222 player) {
        Optional<Vec2i> configuredRtpCenter = EssentialCommands.CONFIG.RTP_CENTER.getPosition();
        if (configuredRtpCenter.isPresent()) {
            Vec2i pair = configuredRtpCenter.get();
            return Optional.of(new class_2382(pair.x(), 0, pair.z()));
        }
        if (EssentialCommands.CONFIG.RTP_CENTER instanceof RtpCenter.Spawn) {
            Optional<MinecraftLocation> worldSpawn = ManagerLocator.getInstance().getWorldDataManager().getSpawn();
            if (worldSpawn.isEmpty()) {
                ECText ecText = ECText.access(player);
                PlayerData.access(player).sendCommandError((class_2561)TextUtil.concat((class_2561[])new class_2561[]{ecText.getText("cmd.rtp.error.pre", TextFormatType.Error, new class_2561[0]), ecText.getText("cmd.rtp.error.no_spawn_set", TextFormatType.Error, new class_2561[0])}));
                return Optional.empty();
            }
            return Optional.of(worldSpawn.get().intPos());
        }
        EssentialCommands.LOGGER.warn("Received no-value (not even default) for RTP_CENTER. (should be 'SPAWN'?)");
        return Optional.empty();
    }

    private static Optional<class_2338> findRtpPosition(class_3218 world, class_2382 center, HeightFinder heightFinder, ExecutionContext ctx) {
        class_2338 targetXZ = RandomTeleportCommand.getRandomXZ(center);
        class_2791 chunk = world.method_22350(targetXZ);
        for (class_2338.class_2339 candidateBlock : RandomTeleportCommand.getChunkCandidateBlocks(chunk.method_12004())) {
            int y;
            int z;
            int x = candidateBlock.method_10263();
            OptionalInt yOpt = heightFinder.getY(chunk, x, z = candidateBlock.method_10260());
            if (yOpt.isEmpty() || !RandomTeleportCommand.isSafePosition(chunk, new class_2338(x, (y = yOpt.getAsInt()) - 2, z), ctx)) continue;
            return Optional.of(new class_2338(x, y, z));
        }
        return Optional.empty();
    }

    private static class_2338 getRandomXZ(class_2382 center) {
        Random rand = new Random();
        int r_max = EssentialCommands.CONFIG.RTP_RADIUS;
        int r_min = EssentialCommands.CONFIG.RTP_MIN_RADIUS;
        int r = r_max == r_min ? r_max : rand.nextInt(r_min, r_max);
        double angle = rand.nextDouble() * 2.0 * Math.PI;
        double delta_x = (double)r * Math.cos(angle);
        double delta_z = (double)r * Math.sin(angle);
        int new_x = center.method_10263() + (int)delta_x;
        int new_z = center.method_10260() + (int)delta_z;
        return new class_2338(new_x, 0, new_z);
    }

    private static boolean isSafePosition(class_2791 chunk, class_2338 pos, ExecutionContext ctx) {
        if (pos.method_10264() <= chunk.method_31607()) {
            return false;
        }
        class_2680 blockState = chunk.method_8320(pos);
        return pos.method_10264() < ctx.topY && blockState.method_26227().method_15769() && blockState.method_26204() != class_2246.field_10036;
    }

    public static Iterable<class_2338.class_2339> getChunkCandidateBlocks(final class_1923 chunkPos) {
        return () -> new Iterator<class_2338.class_2339>(){
            private int _idx = -1;
            private final class_2338.class_2339 _pos = new class_2338.class_2339();

            @Override
            public boolean hasNext() {
                return this._idx < 4;
            }

            @Override
            public class_2338.class_2339 next() {
                ++this._idx;
                return switch (this._idx) {
                    case 0 -> this._pos.method_10103(chunkPos.method_8326(), 0, chunkPos.method_8328());
                    case 1 -> this._pos.method_10103(chunkPos.method_8326(), 0, chunkPos.method_8329());
                    case 2 -> this._pos.method_10103(chunkPos.method_8327(), 0, chunkPos.method_8328());
                    case 3 -> this._pos.method_10103(chunkPos.method_8327(), 0, chunkPos.method_8329());
                    case 4 -> this._pos.method_10103(chunkPos.method_33940(), 0, chunkPos.method_33942());
                    default -> throw new IllegalStateException("Unexpected value: " + this._idx);
                };
            }
        };
    }

    static final class ExecutionContext {
        public final int topY;
        public final int bottomY;

        public ExecutionContext(class_3218 world) {
            this.topY = world.method_31600();
            this.bottomY = world.method_31607();
        }
    }
}

