/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.commands.helpers;

import com.fibermc.essentialcommands.commands.helpers.HeightFinder;
import com.fibermc.essentialcommands.commands.utility.TopCommand;
import java.util.OptionalInt;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_4076;
import net.minecraft.class_5321;

public enum HeightFindingStrategy implements HeightFinder
{
    SKY_TO_SURFACE__FIRST_SOLID(TopCommand::getTop),
    BOTTOM_TO_SKY__FIRST_SAFE_AIR(HeightFindingStrategy::findYBottomUp);

    private final HeightFinder heightFinder;

    private HeightFindingStrategy(HeightFinder heightFinder) {
        this.heightFinder = heightFinder;
    }

    public static HeightFindingStrategy forWorld(class_5321<class_1937> worldRegistryKey) {
        if (worldRegistryKey == class_1937.field_25179 || worldRegistryKey == class_1937.field_25181) {
            return SKY_TO_SURFACE__FIRST_SOLID;
        }
        if (worldRegistryKey == class_1937.field_25180) {
            return BOTTOM_TO_SKY__FIRST_SAFE_AIR;
        }
        return SKY_TO_SURFACE__FIRST_SOLID;
    }

    @Override
    public OptionalInt getY(class_2791 chunk, int x, int z) {
        return this.heightFinder.getY(chunk, x, z);
    }

    private static OptionalInt findYBottomUp(class_2791 chunk, int x, int z) {
        int bottomY;
        int topY = HeightFindingStrategy.getChunkHighestNonEmptySectionYOffsetOrTopY(chunk);
        if (topY <= (bottomY = chunk.method_31607())) {
            return OptionalInt.empty();
        }
        class_2338.class_2339 mutablePos = new class_2338.class_2339(x, bottomY, z);
        class_2680 bsFeet1 = chunk.method_8320((class_2338)mutablePos);
        class_2680 bsBody2 = chunk.method_8320((class_2338)mutablePos.method_10098(class_2350.field_11036));
        while (mutablePos.method_10264() < topY) {
            class_2680 bsHead3 = chunk.method_8320((class_2338)mutablePos.method_10098(class_2350.field_11036));
            if (bsFeet1.method_51367() && bsBody2.method_26215() && bsHead3.method_26215()) {
                return OptionalInt.of(mutablePos.method_10264() - 1);
            }
            bsFeet1 = bsBody2;
            bsBody2 = bsHead3;
        }
        return OptionalInt.empty();
    }

    public static int getChunkHighestNonEmptySectionYOffsetOrTopY(class_2791 chunk) {
        int i = chunk.method_12040();
        return i == chunk.method_31600() ? chunk.method_31607() : class_4076.method_18688((int)chunk.method_31604(i));
    }
}

