/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.commands.suggestions;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.response.NameAndId;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_11560;
import net.minecraft.class_3222;
import net.minecraft.class_8791;
import net.minecraft.server.MinecraftServer;

public class OfflinePlayerRepo {
    private final HashMap<String, NameAndId> gameProfileCache = new HashMap();
    private final MinecraftServer server;
    private final ExecutorService gameProfileExecutor = Executors.newVirtualThreadPerTaskExecutor();

    public OfflinePlayerRepo(MinecraftServer server) {
        this.server = server;
    }

    public CompletableFuture<class_3222> getOfflinePlayerByNameAsync(String playerName) {
        return this.getGameProfile(playerName).handle((gameProfile, throwable) -> gameProfile.map(this::getOfflinePlayer).orElse(null));
    }

    public class_3222 getOfflinePlayer(NameAndId playerProfile) {
        class_3222 player = new class_3222(this.server, this.server.method_30002(), new GameProfile(playerProfile.id(), playerProfile.name()), class_8791.method_53821());
        this.server.method_3760().method_14600(new class_11560(playerProfile.id(), playerProfile.name()));
        return player;
    }

    public CompletableFuture<Optional<NameAndId>> getGameProfile(String playerName) {
        NameAndId profile = this.gameProfileCache.get(playerName);
        if (profile != null) {
            CompletableFuture.completedFuture(profile);
        }
        return this.requestGameProfile(playerName).whenComplete((gameProfile, err) -> gameProfile.ifPresent(nameAndId -> this.gameProfileCache.put(nameAndId.name(), (NameAndId)nameAndId)));
    }

    private CompletableFuture<Optional<NameAndId>> requestGameProfile(String playerName) {
        CompletableFuture<Optional<NameAndId>> completable = new CompletableFuture<Optional<NameAndId>>();
        this.gameProfileExecutor.execute(() -> {
            try {
                completable.complete(this.server.method_73550().comp_839().findProfileByName(playerName));
            }
            catch (Exception ex) {
                completable.completeExceptionally(ex);
            }
        });
        return completable;
    }
}

