/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.mixin;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.config.EssentialCommandsConfig;
import com.fibermc.essentialcommands.events.PlayerDamageCallback;
import com.fibermc.essentialcommands.events.PlayerDeathCallback;
import com.fibermc.essentialcommands.mixin.PlayerEntityMixin;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.playerdata.PlayerDataFactory;
import com.fibermc.essentialcommands.playerdata.PlayerDataManager;
import com.fibermc.essentialcommands.playerdata.PlayerProfile;
import com.fibermc.essentialcommands.playerdata.PlayerProfileFactory;
import com.fibermc.essentialcommands.teleportation.QueuedTeleport;
import com.fibermc.essentialcommands.text.ECText;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5454;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends PlayerEntityMixin
implements ServerPlayerEntityAccess {
    @Unique
    public QueuedTeleport ecQueuedTeleport;
    @Unique
    public PlayerData ec$playerData;
    @Unique
    public PlayerProfile ec$profile;
    @Unique
    public ECText ec$ecText;

    @Shadow
    public abstract class_1934 method_68876();

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    public void onDeath(class_1282 damageSource, CallbackInfo callbackInfo) {
        ((PlayerDeathCallback)PlayerDeathCallback.EVENT.invoker()).onDeath((class_3222)this, damageSource);
    }

    @Inject(method={"damage"}, at={@At(value="RETURN")})
    public void onDamage(class_3218 world, class_1282 damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            ((PlayerDamageCallback)PlayerDamageCallback.EVENT.invoker()).onPlayerDamaged((class_3222)this, damageSource);
        }
    }

    @Inject(method={"changeGameMode"}, at={@At(value="RETURN")})
    public void onChangeGameMode(class_1934 gameMode, CallbackInfoReturnable<Boolean> cir) {
    }

    @Inject(method={"teleportTo(Lnet/minecraft/world/TeleportTarget;)Lnet/minecraft/server/network/ServerPlayerEntity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;sendPlayerStatus(Lnet/minecraft/server/network/ServerPlayerEntity;)V")})
    public void onTeleportBetweenWorlds(class_5454 teleportTarget, CallbackInfoReturnable<class_1297> cir) {
        PlayerData playerData = this.ec$getPlayerData();
        playerData.updatePlayerEntity((class_3222)this);
    }

    @Inject(method={"worldChanged"}, at={@At(value="RETURN")})
    public void onWorldChanged(class_3218 origin, CallbackInfo ci) {
        PlayerData playerData = this.ec$getPlayerData();
        if (EssentialCommands.CONFIG.RECHECK_PLAYER_ABILITY_PERMISSIONS_ON_DIMENSION_CHANGE) {
            PlayerDataManager.getInstance().scheduleTask(playerData::clearAbilitiesWithoutPermisisons);
        }
    }

    @Override
    public QueuedTeleport ec$getQueuedTeleport() {
        return this.ecQueuedTeleport;
    }

    @Override
    public void ec$setQueuedTeleport(QueuedTeleport queuedTeleport) {
        this.ecQueuedTeleport = queuedTeleport;
    }

    @Override
    public QueuedTeleport ec$endQueuedTeleport() {
        QueuedTeleport prevQueuedTeleport = this.ecQueuedTeleport;
        this.ecQueuedTeleport = null;
        return prevQueuedTeleport;
    }

    @Inject(method={"getPlayerListName"}, at={@At(value="RETURN")}, cancellable=true)
    public void getPlayerListName(CallbackInfoReturnable<class_2561> cir) {
        if (EssentialCommandsConfig.getValueSafe(EssentialCommands.BACKING_CONFIG.NICKNAMES_IN_PLAYER_LIST, true).booleanValue()) {
            cir.setReturnValue((Object)((class_3222)this).method_5476());
            cir.cancel();
        }
    }

    @Override
    public PlayerData ec$getPlayerData() {
        if (this.ec$playerData != null) {
            return this.ec$playerData;
        }
        class_3222 playerEntity = (class_3222)this;
        EssentialCommands.LOGGER.info(String.format("[Essential Commands] Loading PlayerData for player with uuid '%s'.", playerEntity.method_5845()));
        PlayerData playerData = PlayerDataFactory.create(playerEntity);
        this.ec$setPlayerData(playerData);
        return playerData;
    }

    @Override
    public void ec$setPlayerData(PlayerData playerData) {
        this.ec$playerData = playerData;
    }

    @Override
    public PlayerProfile ec$getProfile() {
        if (this.ec$profile != null) {
            return this.ec$profile;
        }
        class_3222 playerEntity = (class_3222)this;
        EssentialCommands.LOGGER.info(String.format("[Essential Commands] Loading PlayerProfile for player with uuid '%s'.", playerEntity.method_5845()));
        PlayerProfile profile = PlayerProfileFactory.create(playerEntity);
        this.ec$setProfile(profile);
        return profile;
    }

    @Override
    public void ec$setProfile(PlayerProfile profile) {
        this.ec$profile = profile;
    }

    @Override
    public ECText ec$getEcText() {
        if (this.ec$ecText != null) {
            return this.ec$ecText;
        }
        this.ec$ecText = ECText.forPlayer((class_3222)this);
        return this.ec$ecText;
    }

    @Inject(method={"teleport(Lnet/minecraft/server/world/ServerWorld;DDDLjava/util/Set;FFZ)Z"}, at={@At(value="HEAD")})
    public void onTeleport(class_3218 world, double destX, double destY, double destZ, Set<class_2709> flags, float yaw, float pitch, boolean resetCamera, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_68876() != class_1934.field_9219) {
            this.ec$getPlayerData().setPreviousLocation(new MinecraftLocation((class_3222)this));
        }
    }

    @Inject(method={"enterCombat"}, at={@At(value="RETURN")})
    public void onEnterCombat(CallbackInfo ci) {
        this.ec$playerData.setInCombat(true);
    }

    @Inject(method={"endCombat"}, at={@At(value="RETURN")})
    public void onExitCombat(CallbackInfo ci) {
        this.ec$playerData.setInCombat(false);
    }
}

