/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.teleportation;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.teleportation.PlayerTeleporter;
import com.fibermc.essentialcommands.teleportation.QueuedPlayerTeleport;
import net.minecraft.class_3222;

public class TeleportRequest {
    public final Type type;
    private final PlayerData senderPlayer;
    private final PlayerData targetPlayer;
    private boolean isEnded = false;
    private int ageTicks = 0;

    public class_3222 getSenderPlayer() {
        return this.senderPlayer.getPlayer();
    }

    public class_3222 getTargetPlayer() {
        return this.targetPlayer.getPlayer();
    }

    public PlayerData getSenderPlayerData() {
        return this.senderPlayer;
    }

    public PlayerData getTargetPlayerData() {
        return this.targetPlayer;
    }

    public TeleportRequest(class_3222 senderPlayer, class_3222 targetPlayer, Type requestType) {
        this.type = requestType;
        this.senderPlayer = ((ServerPlayerEntityAccess)senderPlayer).ec$getPlayerData();
        this.targetPlayer = ((ServerPlayerEntityAccess)targetPlayer).ec$getPlayerData();
    }

    public void queue() {
        class_3222 teleportee;
        class_3222 tpDestination;
        if (this.type == Type.TPA_HERE) {
            tpDestination = this.senderPlayer.getPlayer();
            teleportee = this.targetPlayer.getPlayer();
        } else if (this.type == Type.TPA_TO) {
            tpDestination = this.targetPlayer.getPlayer();
            teleportee = this.senderPlayer.getPlayer();
        } else {
            EssentialCommands.LOGGER.warn(String.format("Invalid teleport request type %s", this.type.toString()));
            return;
        }
        PlayerTeleporter.requestTeleport(new QueuedPlayerTeleport(teleportee, tpDestination));
    }

    public void incrementAgeTicks() {
        ++this.ageTicks;
    }

    public int getAgeTicks() {
        return this.ageTicks;
    }

    public void end() {
        PlayerData targetPlayerData = this.getTargetPlayerData();
        if (targetPlayerData != null) {
            targetPlayerData.removeIncomingTeleportRequest(this.getSenderPlayer().method_5667());
            this.getSenderPlayerData().removeSentTeleportRequest(this);
        }
        this.isEnded = true;
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public static enum Type {
        TPA_TO,
        TPA_HERE;

    }
}

